/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.sorting;

import java.util.List;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

public class SortByInventoryCategoryItemNameStrategy
implements SummarySortingStrategy {
    public static final String identifier = "Menu Category Seq Item Name";

    @Override
    public int compare(SalesItem item1, SalesItem item2) {
        Integer categorySequence1 = item1.getLowestSequenceInventoryCategory().getSequence();
        Integer categorySequence2 = item2.getLowestSequenceInventoryCategory().getSequence();
        if (categorySequence1 == 0) {
            categorySequence1 = null;
        }
        if (categorySequence2 == 0) {
            categorySequence2 = null;
        }
        if (categorySequence1 == null && categorySequence2 != null) {
            return -1;
        }
        if (categorySequence2 == null && categorySequence1 != null) {
            return 1;
        }
        if (categorySequence1 != null && categorySequence2 != null && !categorySequence1.equals(categorySequence2)) {
            return categorySequence1.compareTo(categorySequence2);
        }
        if (!item1.getLabel().equals(item2.getLabel())) {
            return item1.getLabel().compareTo(item2.getLabel());
        }
        List<SalesComponent> components = item1.getComponentList();
        SalesComponent component1 = null;
        if (components.size() > 0) {
            component1 = components.get(0);
        }
        components = item2.getComponentList();
        SalesComponent component2 = null;
        if (components.size() > 0) {
            component2 = components.get(0);
        }
        if (component1 != null) {
            if (component2 != null) {
                if (component1 == component2) {
                    return 0;
                }
                if (component2.hasOption()) {
                    if (component1.hasOption()) {
                        SalesOption option1 = component1.getCurrentOptions().get(0);
                        SalesOption option2 = component2.getCurrentOptions().get(0);
                        Integer sequence1 = option1.getOption().getSequence();
                        Integer sequence2 = option2.getOption().getSequence();
                        return sequence1.compareTo(sequence2);
                    }
                    return -1;
                }
                return 1;
            }
            return 1;
        }
        return -1;
    }
}

