/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.sorting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.DocketSorting;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.printSummary.sorting.PropertySortingStrategy;
import ordermate.database.sales.printSummary.sorting.SortByComboThenInventoryGroupItemNameStrategy;
import ordermate.database.sales.printSummary.sorting.SortByComboThenSequenceItemNameStrategy;
import ordermate.database.sales.printSummary.sorting.SortByCreationTime;
import ordermate.database.sales.printSummary.sorting.SortByInventoryGroupItemNameStrategy;
import ordermate.database.sales.printSummary.sorting.SortByItemSequences;
import ordermate.database.sales.printSummary.sorting.SortByNone;
import ordermate.database.sales.printSummary.sorting.SortBySeats;
import ordermate.database.sales.printSummary.sorting.SortBySequences;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;
import org.apache.commons.lang.ArrayUtils;

public class SortingStrategyVendor {
    private static Map<String, SummarySortingStrategy> sortingStrategies = new HashMap<String, SummarySortingStrategy>();
    private static SortingStrategyVendor instance;

    private SortingStrategyVendor() {
    }

    public static Set getSortingStrategiesIDSet() {
        return sortingStrategies.keySet();
    }

    public static SortingStrategyVendor getInstance() {
        return instance;
    }

    public static SummarySortingStrategy getDefaultSortingStrategy() {
        return SortingStrategyVendor.getSortingStrategy(SystemProperty.getInstance().getDefaultDocketSorting().toString());
    }

    public static SummarySortingStrategy getSortingStrategy(String identifier) {
        if (sortingStrategies.containsKey(identifier)) {
            return sortingStrategies.get(identifier);
        }
        OrderMate.LOG.warn(identifier + " : was not found in list of sorting strategies.  Available sorting strategies are: " + ArrayUtils.toString((Object)SortingStrategyVendor.getSortingStrategiesIDSet().toArray(new String[SortingStrategyVendor.getSortingStrategiesIDSet().size()])));
        return new SortByInventoryGroupItemNameStrategy();
    }

    public static Collection<SummarySortingStrategy> getSortingStrategies() {
        return sortingStrategies.values();
    }

    public static SummarySortingStrategy getSortingStrategy(DocketSorting sorting, String defaultWay) {
        if (sorting != null) {
            if (!sortingStrategies.containsKey(sorting.getID().toString())) {
                PropertySortingStrategy strategy = PropertySortingStrategy.createStrategy(sorting);
                sortingStrategies.put(sorting.getID().toString(), strategy);
            }
            return sortingStrategies.get(sorting.getID().toString());
        }
        return SortingStrategyVendor.getSortingStrategy(defaultWay);
    }

    static {
        sortingStrategies.put("Menu Group Seq Item Name", new SortByInventoryGroupItemNameStrategy());
        sortingStrategies.put("None", new SortByNone());
        sortingStrategies.put("Item Creation Time", new SortByCreationTime());
        sortingStrategies.put("Sequences", new SortBySequences());
        sortingStrategies.put("Combo then Group then Item Name", new SortByComboThenInventoryGroupItemNameStrategy());
        sortingStrategies.put("Combo then Sequence then Item Name", new SortByComboThenSequenceItemNameStrategy());
        sortingStrategies.put("Item Sequences", new SortByItemSequences());
        sortingStrategies.put("Seats", new SortBySeats());
        instance = new SortingStrategyVendor();
    }
}

