/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.reservation;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.reservation.ReservationAccount;
import ordermate.database.sales.reservation.ReservationAccountState;
import ordermate.database.sales.reservation.ReservationDeposit;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_reservation")
@AccessType(value="property")
public class Reservation
extends PersistentObject
implements Saveable,
Displayable {
    private final String SEVENROOMS = "SevenRooms";
    private final String NOWBOOKIT = "NowBookIt";
    public static final Props Properties = new Props();
    public static final String ARRIVED = "ARRIVED";
    public static final String BOOKED = "BOOKED";
    public static final String CONFIRMED = "CONFIRMED";
    private static final Color ARRIVED_COLOR = new Color(150, 150, 150);
    private static final Color CONFIRMED_COLOR = new Color(0, 255, 0);
    private static final Color BOOKED_COLOR = new Color(255, 0, 0);
    private static final Color PRESSED_COLOR = new Color(204, 204, 204);
    private Reference<Customer> customer;
    private Reference<Account> tableAccount;
    private Date time;
    private Date date;
    private int numPatrons;
    private Reference<TableGroup> section;
    private String comments;
    private String reservationState;
    private String systemState;
    private String externalId;
    private String tables;
    private Date leaveTime;
    public final String CUSTOMER_WALK_IN = "Walk-in";
    private PersistentWriteableList<ReservationAccount> accountLinks;
    private PersistentWriteableList<ReservationDeposit> deposits;

    public Reservation() {
        this.customer = this.createReference(Reservation.Properties.CUSTOMER);
        this.tableAccount = this.createReference(Reservation.Properties.TABLE_ACCOUNT);
        this.section = this.createReference(Reservation.Properties.SECTION);
        this.reservationState = BOOKED;
        this.systemState = "ACTIVE";
        this.CUSTOMER_WALK_IN = "Walk-in";
        this.accountLinks = this.createWriteableList(Reservation.Properties.ACCOUNT_LINKS);
        this.deposits = this.createWriteableList(Reservation.Properties.DEPOSITS);
    }

    public Reservation(Customer theCustomer, Date theTime, Date theDate, int patrons, TableGroup theSection, String newComments) {
        this.customer = this.createReference(Reservation.Properties.CUSTOMER);
        this.tableAccount = this.createReference(Reservation.Properties.TABLE_ACCOUNT);
        this.section = this.createReference(Reservation.Properties.SECTION);
        this.reservationState = BOOKED;
        this.systemState = "ACTIVE";
        this.CUSTOMER_WALK_IN = "Walk-in";
        this.accountLinks = this.createWriteableList(Reservation.Properties.ACCOUNT_LINKS);
        this.deposits = this.createWriteableList(Reservation.Properties.DEPOSITS);
        this.customer.set(theCustomer);
        this.time = theTime;
        this.date = theDate;
        this.numPatrons = patrons;
        this.comments = newComments;
        this.section.set(theSection);
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.getCustomer() != null) {
            StringBuilder SB = new StringBuilder();
            SB.append("<html><left>").append(this.getCustomer().getName()).append("- ").append(DateTimeUtils.convertToTwelveHourTime(this.time)).append(", ");
            if (this.getSection() != null) {
                SB.append("Section ").append(this.getSection().getName()).append(", ");
            }
            SB.append(this.numPatrons).append(" patrons").append("<html></left>");
            return SB.toString();
        }
        return "New Reservation";
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer newCustomer) {
        this.customer.set(newCustomer);
    }

    @Transient
    public String getCustomerName() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getNameAndTitle();
        }
        return "Walk-in";
    }

    @Column(name="time")
    @Temporal(value=TemporalType.TIME)
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date newTime) {
        this.time = newTime;
    }

    @Column(name="leave_time")
    @Temporal(value=TemporalType.TIME)
    public Date getLeaveTime() {
        return this.leaveTime;
    }

    public void setLeaveTime(Date newTime) {
        this.leaveTime = newTime;
    }

    @Column(name="date")
    @Temporal(value=TemporalType.DATE)
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date newDate) {
        this.date = newDate;
    }

    @Column(name="patrons")
    public Integer getNumPatrons() {
        return this.numPatrons;
    }

    public void setNumPatrons(Integer newNumPatrons) {
        this.numPatrons = newNumPatrons != null ? newNumPatrons : 0;
    }

    @Column(name="comments")
    public String getComments() {
        return this.comments;
    }

    @Transient
    public String getCommentsSafe() {
        String potentiallyNullComments = this.getComments();
        if (potentiallyNullComments == null) {
            this.setComments("");
        }
        return this.getComments();
    }

    public void setSection(TableGroup theSection) {
        this.section.set(theSection);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_table_group")
    public TableGroup getSection() {
        return this.section.get();
    }

    @Transient
    public String getSectionLabel() {
        if (this.getSection() != null) {
            return this.getSection().getLabel();
        }
        return "";
    }

    public void setComments(String newComments) {
        this.comments = newComments;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.reservationState.equals(ARRIVED)) {
            return ARRIVED_COLOR;
        }
        if (this.reservationState.equals(BOOKED)) {
            return BOOKED_COLOR;
        }
        if (this.reservationState.equals(CONFIRMED)) {
            return CONFIRMED_COLOR;
        }
        return null;
    }

    public void deleteReservation() {
        this.systemState = "DELETED";
    }

    public void setReservationState(String state) {
        this.reservationState = state;
    }

    @Column(name="reservation_state")
    public String getReservationState() {
        return this.reservationState;
    }

    @ManyToOne
    @JoinColumn(name="FK_table_account")
    public Account getTableAccount() {
        return this.tableAccount.get();
    }

    public void setTableAccount(Account tableAccount) {
        this.tableAccount.set(tableAccount);
    }

    @Column(name="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public Color getPressedColor() {
        return PRESSED_COLOR;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        if (this.accountLinks != null && !this.accountLinks.isEmpty()) {
            this.accountLinks.saveChild();
        }
        if (this.deposits != null && !this.deposits.isEmpty()) {
            this.deposits.saveChild();
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    protected void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Transient
    public String getTimeString() {
        return this.getTime() == null ? "" : DateTimeUtils.getSimpleTimeFormat().format(this.getTime());
    }

    @Transient
    public String getLeaveTimeString() {
        return this.getLeaveTime() == null ? "" : DateTimeUtils.getSimpleTimeFormat().format(this.getLeaveTime());
    }

    @Transient
    public String getConfirmedString() {
        if (CONFIRMED.equals(this.getReservationState())) {
            return "Y";
        }
        if (ARRIVED.equals(this.getReservationState())) {
            return ARRIVED;
        }
        return "";
    }

    @Column(name="tables")
    public String getTables() {
        return this.tables;
    }

    public void setTables(String tables) {
        this.tables = tables;
    }

    @OneToMany(mappedBy="reservation", targetEntity=ReservationAccount.class)
    protected List<ReservationAccount> getAccountLinks() {
        return this.accountLinks;
    }

    protected void setAccountLinks(List<ReservationAccount> values) {
        this.accountLinks.set(values);
    }

    @OneToMany(mappedBy="reservation", targetEntity=ReservationDeposit.class)
    public List<ReservationDeposit> getDeposits() {
        return this.deposits;
    }

    public void setDeposits(List<ReservationDeposit> values) {
        this.deposits.set(values);
    }

    public void applyDeposits() {
        Account toModify = this.getTableAccount();
        if (toModify == null) {
            return;
        }
        for (ReservationDeposit deposit : this.deposits) {
            String txnRef = deposit.getTxnRef();
            if (txnRef == null) {
                OrderMate.LOG.warn("Will not auto-apply deposit without a transaction reference");
                continue;
            }
            boolean found = false;
            for (FinanceTransaction txn : toModify.getFinanceTransactions()) {
                if (!(txn instanceof WebTransaction) || !txnRef.equals(((WebTransaction)txn).getTransactionReference())) continue;
                found = true;
                break;
            }
            if (!found) {
                Terminal servermate = Terminal.getServerMateTerminal();
                FinanceUnit onlineUnit = FinanceUnit.getUnitForName(deposit.getIssuer());
                if (onlineUnit == null) {
                    onlineUnit = deposit.getIssuer().equals("SevenRooms") || deposit.getIssuer().equals("NowBookIt") ? FinanceUnit.createUnit(FinanceUnit.WEB_TYPE, deposit.getIssuer(), false, true) : FinanceUnit.createUnit(FinanceUnit.WEB_TYPE, deposit.getIssuer(), false, false);
                }
                WebTransaction newTxn = new WebTransaction(User.getSystemUser(), servermate, new Price(deposit.getAmountPaid(), 0.01), Price.ZERO_DOLLAR, CashDrawer.getOnlineCashDrawer(servermate, User.getSystemUser()), onlineUnit, servermate.getShift());
                newTxn.setTransactionReference(txnRef);
                toModify.addFinanceTransaction(newTxn);
                continue;
            }
            OrderMate.LOG.warn("Will not apply transaction, already exists " + txnRef + " for " + toModify);
        }
    }

    @Transient
    public List<Account> getLinkedAccounts() {
        ArrayList<Account> accountList = new ArrayList<Account>();
        for (ReservationAccount resAccLink : this.accountLinks) {
            if (!resAccLink.getAccountState().equals((Object)ReservationAccountState.OPEN) && !resAccLink.getAccountState().equals((Object)ReservationAccountState.CLOSED)) continue;
            accountList.add(resAccLink.getAccount());
        }
        return accountList;
    }

    public void linkAccount(Account account) {
        if (this.isNewAccount(account)) {
            ReservationAccount accountLink = new ReservationAccount(this, account);
            this.accountLinks.add(accountLink);
        }
        this.applyDeposits();
    }

    public void delinkAccountByClosing(Account account) {
        ReservationAccount resAccount = this.getReservationAccount(account);
        if (resAccount != null) {
            resAccount.closeAccount();
        }
    }

    public void delinkAccountByMoving(Account account) {
        ReservationAccount resAccount = this.getReservationAccount(account);
        if (resAccount != null) {
            resAccount.moveAccount();
        }
    }

    private ReservationAccount getReservationAccount(Account account) {
        for (ReservationAccount resAccount : this.accountLinks) {
            if (!resAccount.getAccount().equals(account)) continue;
            return resAccount;
        }
        return null;
    }

    private boolean isNewAccount(Account account) {
        return this.getReservationAccount(account) == null;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property RESERVATION_STATE;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property TIME;
        public PropertiedObject.Property<Date> DATE;
        public PropertiedObject.Property NUM_PATRONS;
        public PropertiedObject.Property<TableGroup> SECTION;
        public PropertiedObject.Property<String> COMMENTS;
        public PropertiedObject.Property SYSTEM_STATE;
        public PersistentObject.DerivedProperty<String> CUSTOMER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Reservation.class), "customerName");
        public PersistentObject.DerivedProperty<Date> TIME_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Reservation.class), "timeString");
        public PersistentObject.DerivedProperty CONFIRMED_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Reservation.class), "confirmedString");
        public PropertiedObject.Property<Account> TABLE_ACCOUNT;
        public PropertiedObject.Property<String> EXTERNAL_ID;
        public PropertiedObject.Property<String> TABLES;
        public PropertiedObject.Property LEAVE_TIME;
        public PropertiedObject.Property<ReservationAccount> ACCOUNT_LINKS;
        public PropertiedObject.Property<ReservationDeposit> DEPOSITS;
    }
}

