/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.reservation;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationAccountState;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_reservation_account")
@AccessType(value="property")
public class ReservationAccount
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Reservation> reservation;
    private Reference<Account> account;
    private ReservationAccountState accountState;

    @Deprecated
    public ReservationAccount() {
        this.reservation = this.createReference(ReservationAccount.Properties.RESERVATION);
        this.account = this.createReference(ReservationAccount.Properties.ACCOUNT);
        this.accountState = ReservationAccountState.OPEN;
    }

    public ReservationAccount(Reservation res, Account acc) {
        this.reservation = this.createReference(ReservationAccount.Properties.RESERVATION);
        this.account = this.createReference(ReservationAccount.Properties.ACCOUNT);
        this.accountState = ReservationAccountState.OPEN;
        if (res == null) {
            throw new IllegalArgumentException("Reservation cannot be null!");
        }
        if (acc == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        this.reservation.set(res);
        this.account.set(acc);
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_reservation")
    public Reservation getReservation() {
        return this.reservation.get();
    }

    public void setReservation(Reservation res) {
        this.reservation.set(res);
    }

    @OneToOne
    @JoinColumn(name="fk_sales_account")
    public Account getAccount() {
        return this.account.get();
    }

    public void setAccount(Account acc) {
        this.account.set(acc);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Column(name="account_state")
    @Enumerated(value=EnumType.STRING)
    public ReservationAccountState getAccountState() {
        return this.accountState;
    }

    protected void setAccountState(ReservationAccountState value) {
        this.accountState = value;
    }

    public void closeAccount() {
        this.setAccountState(ReservationAccountState.CLOSED);
        this.saveChild();
    }

    public void moveAccount() {
        this.setAccountState(ReservationAccountState.MOVED);
        this.saveChild();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Reservation> RESERVATION;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<ReservationAccountState> ACCOUNT_STATE;
    }
}

