/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.reservation;

import au.com.diamondback.xmlintegration.booking.DiamondBookingPayment;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.sales.reservation.Reservation;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_reservation_deposit")
@AccessType(value="property")
public class ReservationDeposit
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Reservation> reservation;
    private String type;
    private String issuer;
    private Date datePaid;
    private String txnRef;
    private BigDecimal amountPaid;

    public ReservationDeposit() {
        this.reservation = this.createReference(ReservationDeposit.Properties.RESERVATION);
    }

    public ReservationDeposit(DiamondBookingPayment payment) {
        this.reservation = this.createReference(ReservationDeposit.Properties.RESERVATION);
        this.type = payment.getType();
        this.issuer = payment.getIssuer();
        this.datePaid = payment.getDatePaid() != null ? payment.getDatePaid().toGregorianCalendar().getTime() : new Date();
        this.txnRef = payment.getTxnRef();
        this.amountPaid = payment.getAmountPaid();
    }

    @Column(name="FK_sales_reservation")
    public Reference<Reservation> getReservation() {
        return this.reservation;
    }

    public void setReservation(Reference<Reservation> reservation) {
        this.reservation = reservation;
    }

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="issuer")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Column(name="date_paid")
    @Temporal(value=TemporalType.DATE)
    public Date getDatePaid() {
        return this.datePaid;
    }

    public void setDatePaid(Date datePaid) {
        this.datePaid = datePaid;
    }

    @Column(name="txn_ref")
    public String getTxnRef() {
        return this.txnRef;
    }

    public void setTxnRef(String txnRef) {
        this.txnRef = txnRef;
    }

    @Column(name="amount_paid")
    public BigDecimal getAmountPaid() {
        return this.amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Reservation> RESERVATION;
        public PropertiedObject.Property<String> TYPE;
        public PropertiedObject.Property<String> ISSUER;
        public PropertiedObject.Property<Date> DATEPAID;
        public PropertiedObject.Property<String> TXN_REF;
        public PropertiedObject.Property<Price> AMOUNT_PAID;
    }
}

