/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.reservation;

public class ReservationHeader {
    private final String time;
    private final String customer;

    private ReservationHeader(ReservationHeaderBuilder builder) {
        this.time = builder.time;
        this.customer = builder.customer;
    }

    public String getTime() {
        return this.time;
    }

    public String getCustomer() {
        return this.customer;
    }

    public static class ReservationHeaderBuilder {
        private final String time;
        private final String customer;

        public ReservationHeaderBuilder(String time, String customer) {
            if (time == null || customer == null) {
                throw new IllegalArgumentException("Time or customer of the reservation pointer cannot be null!");
            }
            this.time = time;
            this.customer = customer;
        }

        public ReservationHeader build() {
            return new ReservationHeader(this);
        }
    }
}

