/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.reservation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.StringUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ordermate.database.queries.sales.reservation.ReservationQueries;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;

public class ReservationsHelper {
    public static final String HIGHLIGHT_COLOR = "green";
    static final int MAX_DURATION_OPTIONS = 9;

    public static List<Reservation> getReservationsForDay(java.util.Date theDate, boolean unallocatedOnly) {
        Date day = new Date(theDate.getTime());
        ObjectQuery query = Query.select(Reservation.class).active(Reservation.class).equals(Reservation.Properties.DATE, day, SQLDateType.DATE);
        if (unallocatedOnly) {
            query = query.not().equals(Reservation.Properties.RESERVATION_STATE, "ARRIVED");
        }
        query = query.orderBy(Reservation.Properties.TIME).orderBy(Reservation.Properties.ID);
        return PersistenceManager.getObjectList(Reservation.class, query.toString(), null);
    }

    public static List<Reservation> getReservations(java.util.Date theDate, TableGroup theSection, boolean unallocatedOnly) {
        Date day = new Date(theDate.getTime());
        ObjectQuery query = Query.select(Reservation.class);
        query = query.equals(Reservation.Properties.DATE, day, SQLDateType.DATE).equals(Reservation.Properties.SECTION, theSection.getID());
        if (unallocatedOnly) {
            query = query.not().equals(Reservation.Properties.RESERVATION_STATE, "ARRIVED");
        }
        query = query.active(Reservation.class).orderBy(Reservation.Properties.TIME).orderBy(Reservation.Properties.TIME);
        return PersistenceManager.getObjectList(Reservation.class, query.toString(), null);
    }

    public static List<Reservation> getReservationsForTableAccount(TableAccount tableAcc) {
        if (tableAcc.getID() == null) {
            return Collections.emptyList();
        }
        ObjectQuery query = Query.select(Reservation.class);
        query = query.equals(Reservation.Properties.SYSTEM_STATE, "ACTIVE").equals(Reservation.Properties.TABLE_ACCOUNT, tableAcc.getID()).orderBy(Reservation.Properties.ID, false);
        return PersistenceManager.getObjectList(Reservation.class, query.toString(), null);
    }

    public static Reservation getFirstReservationForTableAccount(TableAccount tableAcc) {
        List<Reservation> reservations = ReservationsHelper.getReservationsForTableAccount(tableAcc);
        if (!reservations.isEmpty()) {
            return reservations.get(0);
        }
        return null;
    }

    public static Reservation getReservation(TableAccount account, String reservationState) {
        ObjectQuery query = Query.select(Reservation.class);
        query = query.equals(Reservation.Properties.SYSTEM_STATE, "ACTIVE").equals(Reservation.Properties.TABLE_ACCOUNT, account.getID());
        if (reservationState != null) {
            query.equals(Reservation.Properties.RESERVATION_STATE, reservationState);
        }
        return PersistenceManager.getObject(Reservation.class, query.toString());
    }

    public static Reservation getReservationByExternalID(Long bookingID) {
        ObjectQuery query = Query.select(Reservation.class);
        query = query.equals(Reservation.Properties.EXTERNAL_ID, bookingID);
        return PersistenceManager.getObject(Reservation.class, query.toString(), null);
    }

    public static boolean isReservationExists(Long bookingID) {
        return ReservationsHelper.getReservationByExternalID(bookingID) != null;
    }

    public static List<Reservation> getExternalReservations(java.util.Date minDate, java.util.Date maxDate) {
        return PersistenceManager.getObjectList(Reservation.class, ReservationQueries.getQueryForExternalReservations(minDate, maxDate).toString(), null);
    }

    public static List<Reservation> getOverlappedReservations(String tableNames, TableGroup section, java.util.Date theDate, java.util.Date arrivalTime, java.util.Date leaveTime) {
        ObjectQuery query = Query.select(Reservation.class).equals(Reservation.Properties.SYSTEM_STATE, "ACTIVE");
        query.equals(Reservation.Properties.RESERVATION_STATE, "BOOKED");
        query.equals(Reservation.Properties.SECTION, section);
        query.equals(Reservation.Properties.DATE, theDate, SQLDateType.DATE);
        if (leaveTime != null) {
            query.lessThan(Reservation.Properties.TIME, leaveTime, SQLDateType.TIME);
        }
        if (arrivalTime != null) {
            query.greaterThan(Reservation.Properties.LEAVE_TIME, arrivalTime, SQLDateType.TIME);
        }
        query.not().isNull(Reservation.Properties.TABLES);
        List<Reservation> reservations = PersistenceManager.getObjectList(Reservation.class, query.toString());
        HashSet<Reservation> overlappedReservations = new HashSet<Reservation>();
        for (Reservation reservation : reservations) {
            if (!ReservationsHelper.isReservationTableMatching(reservation, tableNames)) continue;
            overlappedReservations.add(reservation);
        }
        return new ArrayList<Reservation>(overlappedReservations);
    }

    public static List<Reservation> getOverlappedReservations(LogicalTable logicalTable, java.util.Date theDate, java.util.Date arrivalTime, java.util.Date leaveTime) {
        String tableNames = LogicalTableQueries.getTableNames(logicalTable);
        return ReservationsHelper.getOverlappedReservations(tableNames, logicalTable.getTableGroup(), theDate, arrivalTime, leaveTime);
    }

    public static List<Reservation> getOverlappedReservations(LogicalTable logicalTable, int minBookingTime) {
        Calendar cal = Calendar.getInstance();
        java.util.Date theDate = cal.getTime();
        java.util.Date arrivalTime = cal.getTime();
        java.util.Date leaveTime = DateTimeUtils.addTime(theDate, 12, minBookingTime);
        return ReservationsHelper.getOverlappedReservations(logicalTable, theDate, arrivalTime, leaveTime);
    }

    public static List<Reservation> getUnarrivedReservations(java.util.Date minDate, LogicalTable logicalTable) {
        List<Reservation> reservations = PersistenceManager.getObjectList(Reservation.class, ReservationQueries.getUnarrivedReservationsQry(minDate, logicalTable).toString());
        ArrayList<Reservation> futureReservations = new ArrayList<Reservation>();
        if (!reservations.isEmpty()) {
            String tableNames = LogicalTableQueries.getTableNames(logicalTable);
            for (Reservation reservation : reservations) {
                if (!ReservationsHelper.isReservationTableMatching(reservation, tableNames)) continue;
                futureReservations.add(reservation);
            }
        }
        return futureReservations;
    }

    public static List<Integer> getDurationTimeOptions(Reservation reservation, int minTimeSlot) {
        int countOfPotentialDurationTime;
        ArrayList<Integer> durationTimeList = new ArrayList<Integer>();
        if (reservation != null) {
            java.util.Date visitDate = DateTimeUtils.mergeDateAndTime(reservation.getDate(), reservation.getTime());
            long minutes = DateTimeUtils.getDifferenceInMillisecs(new java.util.Date(), visitDate) / 60000L;
            countOfPotentialDurationTime = (int)minutes / minTimeSlot;
            if (countOfPotentialDurationTime > 9) {
                countOfPotentialDurationTime = 9;
            }
        } else {
            countOfPotentialDurationTime = 9;
        }
        for (int i = 1; i <= countOfPotentialDurationTime; ++i) {
            durationTimeList.add(i * minTimeSlot);
        }
        return durationTimeList;
    }

    public static String getOverlappedReservationsMsg(List<Reservation> reservations, Reservation currentReservation) {
        StringBuilder msg = new StringBuilder();
        for (Reservation res : reservations) {
            if (currentReservation != null && currentReservation.getExternalId().equals(res.getExternalId())) continue;
            msg.append(HtmlUtils.newline(1)).append(HtmlUtils.addSpaces(5));
            msg.append(ReservationsHelper.getOverlappedReservationMsg(res));
        }
        return msg.toString();
    }

    private static String getOverlappedReservationMsg(Reservation res) {
        return HtmlUtils.boldColor(res.getCustomerName(), HIGHLIGHT_COLOR) + " booked on table " + HtmlUtils.boldColor(res.getTables(), HIGHLIGHT_COLOR) + " between " + HtmlUtils.boldColor(res.getTimeString(), HIGHLIGHT_COLOR) + " and " + HtmlUtils.boldColor(res.getLeaveTimeString(), HIGHLIGHT_COLOR);
    }

    private static boolean isReservationTableMatching(Reservation reservation, String tableNames) {
        HashSet<String> reservationTables = new HashSet<String>(Arrays.asList(reservation.getTables().split(",")));
        for (String tableName : StringUtils.splitToList(tableNames, ",")) {
            if (!reservationTables.contains(tableName)) continue;
            return true;
        }
        return false;
    }

    public static enum ReservationFilter {
        All,
        Unconfirmed,
        Unallocated;

    }
}

