/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.schedule;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.schedule.ReScheduleExecutor;
import ordermate.scheduler.Recurrence;
import ordermate.scheduler.RecurrenceParser;
import ordermate.scheduler.Task;
import ordermate.scheduler.TaskFactory;
import org.apache.logging.log4j.Level;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_scheduled_task")
@AccessType(value="property")
public class Schedule
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private String recurrence;
    private String task;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Serializable data;
    private transient Task explicitTask;

    public static List<Schedule> findAll() {
        return PersistenceManager.getObjectList(Schedule.class, Query.select(Schedule.class).active(Schedule.class).toString(), null);
    }

    public static Schedule findByLabel(String label) {
        return PersistenceManager.getObject(Schedule.class, Query.select(Schedule.class).active(Schedule.class).equalsParam(Schedule.Properties.LABEL).toString(), new Object[]{label});
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="recurrence")
    public String getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(String recurrence) {
        this.recurrence = recurrence;
    }

    @Column(name="task")
    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public Task toTask() {
        if (this.explicitTask != null) {
            return this.explicitTask;
        }
        return TaskFactory.getTask(this.task);
    }

    public void setExplicitTask(Task theTaskToPerform) {
        this.explicitTask = theTaskToPerform;
    }

    @Transient
    public boolean isValidRecurrence() {
        if (this.recurrence == null || this.recurrence.isEmpty()) {
            return false;
        }
        try {
            Recurrence recurrenceInstance = this.toRecurrence();
            return recurrenceInstance.isAtReboot() || recurrenceInstance.isAtTradingDay() || recurrenceInstance.isAtAutosend() || recurrenceInstance.getNextValidTimeAfter(new Date()) != null;
        }
        catch (ParseException ex) {
            OrderMate.LOG.info(ex.getMessage());
            return false;
        }
    }

    @Transient
    public boolean isValidtask() {
        Task taskInstance = this.toTask();
        return taskInstance != null;
    }

    public Recurrence toRecurrence() throws ParseException {
        return new RecurrenceParser(this.recurrence);
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        try {
            PersistenceManager.getServerConnection().runSync(new ReScheduleExecutor(this));
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot run sync for Reschedule Executor", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.label + ": " + this.task + "[" + this.recurrence + "]";
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    public void setData(Serializable newData) {
        this.data = newData;
    }

    public Serializable getData() {
        return this.data;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> RECURRENCE;
        public PropertiedObject.Property<String> TASK;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Serializable> DATA;
    }
}

