/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.QueryComponent;
import au.com.ordermate.oquery.search.QueryModifier;
import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.oquery.search.filter.AbstractSearcher;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.persistence.ArrayObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.SearchFilterI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.searchers.ComparableMultiKey;

public abstract class ArrayObjectSearcher
extends AbstractSearcher<ArrayObject> {
    protected List<String> columns;
    private List<QueryModifier> modifiers;
    private Collection<String> restrictions;

    public ArrayObjectSearcher() {
        super(ArrayObject.class);
        this.initColumns();
    }

    protected void initColumns() {
        this.columns = new ArrayList<String>();
        this.columns.addAll(this.createStaticColumns());
    }

    public List<String> getPossibleColumns() {
        return new ArrayList<String>(this.columns);
    }

    public HashMap<String, Integer> mapPossibleColumns() {
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        List<String> possibleCols = this.getPossibleColumns();
        for (int i = 0; i < possibleCols.size(); ++i) {
            columnMap.put(possibleCols.get(i), i);
        }
        return columnMap;
    }

    protected abstract ObjectQuery createBaseQuery();

    public void setGroupBy(PropertiedObject.Property ... groupBy) {
        if (this.modifiers != null && this.modifiers.size() > 0) {
            HashSet<QueryModifier> toRemove = new HashSet<QueryModifier>();
            for (QueryModifier mod : this.modifiers) {
                if (!(mod instanceof PropertyGroup)) continue;
                toRemove.add(mod);
            }
            this.modifiers.removeAll(toRemove);
        }
        if (groupBy != null) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<QueryModifier>();
            }
            for (PropertiedObject.Property prop : groupBy) {
                this.modifiers.add(new PropertyGroup(prop));
            }
        }
    }

    public void setQueryModifiers(List<QueryModifier> mods) {
        ArrayList<QueryModifier> newMods = new ArrayList<QueryModifier>();
        if (this.modifiers != null && this.modifiers.size() > 0) {
            for (QueryModifier mod : this.modifiers) {
                if (!(mod instanceof PropertyGroup)) continue;
                newMods.add(mod);
            }
        }
        newMods.addAll(mods);
        this.modifiers = newMods;
    }

    public void setSelectRestrictions(Collection<String> cols) {
        this.restrictions = cols;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ExperimentalFeature doRestrict;
        ObjectQuery query = this.createBaseQuery();
        query = this.applySearchFilters(query);
        if (this.modifiers != null) {
            for (QueryModifier modifier : this.modifiers) {
                query = modifier.modifyQuery(query);
            }
        }
        if (this.restrictions != null && (doRestrict = ExperimentalFeature.find("Custom Report Optimise")) != null && doRestrict.getBooleanValue(Boolean.FALSE).booleanValue()) {
            this.modifyQueryRestrictions(query);
        }
        return query;
    }

    private void modifyQueryRestrictions(ObjectQuery query) {
        ArrayList<QueryComponent> toModify = new ArrayList<QueryComponent>(query.getSelects());
        for (QueryComponent component : toModify) {
            String name;
            component.resolve(PersistenceManager.getPersistenceMetaData());
            String col = component.toString();
            int index = (col = col.replace("`", "")).lastIndexOf(" ");
            if (index <= 0 || this.restrictions.contains(name = col.substring(index + 1))) continue;
            query.replaceSelect(component, "0", name);
        }
    }

    protected final ObjectQuery applySearchFilters(ObjectQuery query) {
        ObjectQuery localQuery = query;
        for (SearchFilterI nextFilter : this.getSearchFilters()) {
            if (!(nextFilter instanceof QuerySearchFilter)) continue;
            localQuery = ((QuerySearchFilter)nextFilter).addQueryRestriction(localQuery);
        }
        return localQuery;
    }

    @Override
    public List<ArrayObject> search() {
        if (this.isActive()) {
            ObjectQuery query = this.getObjectQuery();
            Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
            ArrayList<ArrayObject> list = new ArrayList<ArrayObject>();
            this.populateResults(list, results);
            return list;
        }
        return Collections.emptyList();
    }

    protected void populateResults(List<ArrayObject> list, Object[][] results) {
        ArrayList<Integer> groups = new ArrayList<Integer>();
        if (this.modifiers != null) {
            int selectCols = 0;
            for (int i = 0; i < this.modifiers.size(); ++i) {
                QueryPart queryPart = this.modifiers.get(i).getQueryPart();
                if (QueryPart.GROUP.equals((Object)queryPart)) {
                    groups.add(selectCols + this.columns.size());
                    ++selectCols;
                    continue;
                }
                if (!QueryPart.SELECT.equals((Object)queryPart)) continue;
                ++selectCols;
            }
        }
        if (groups.size() == 0) {
            for (Object[] nextResult : results) {
                list.add(new ArrayObject(null, nextResult));
            }
        } else if (groups.size() == 1) {
            for (Object[] nextResult : results) {
                list.add(new ArrayObject(nextResult[nextResult.length - 1], nextResult));
            }
        } else {
            for (Object[] nextResult : results) {
                Object[] id = new Object[groups.size()];
                for (int i = 0; i < groups.size(); ++i) {
                    id[i] = nextResult[(Integer)groups.get(i)];
                }
                list.add(new ArrayObject(new ComparableMultiKey(id), nextResult));
            }
        }
    }

    protected abstract List<String> createStaticColumns();

    class PropertyGroup
    implements QueryModifier {
        private final PropertiedObject.Property prop;

        public PropertyGroup(PropertiedObject.Property value) {
            this.prop = value;
        }

        @Override
        public ObjectQuery modifyQuery(ObjectQuery query) {
            query.select(this.prop);
            query.groupBy(this.prop);
            query.orderBy(this.prop);
            return query;
        }

        @Override
        public QueryPart getQueryPart() {
            return QueryPart.GROUP;
        }
    }
}

