/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers;

import au.com.ordermate.glazedlists.ChangeableMatcherEditor;
import au.com.ordermate.glazedlists.CountedPrefixComparator;
import au.com.ordermate.glazedlists.DefaultTermPrefixMatcher;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.glazedlists.StringComparator;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.List;

public class DefaultMatcherSearcher<T> {
    protected AbstractMatcherEditor<T> primaryEditor;
    private DefaultTermPrefixMatcher<T> prefixMatcher;
    private ChangeableMatcherEditor<T> prefixEditor;
    private TextMatcherEditor<T> labelEditor;
    private TextFilterator<T> labelFilterator;
    private Stringifier<T> labelStringifier = this.createStringifier();
    protected SequentialComparator<T> masterComparator;
    protected CountedPrefixComparator<T> prefixComp;
    protected StringComparator<T> labelComp;
    private SortedList<T> sortedItems;
    private FilterList<T> filteredItems;

    public DefaultMatcherSearcher() {
        this.setupLists();
    }

    protected Stringifier<T> createStringifier() {
        return new ToStringifier();
    }

    private void setupLists() {
        this.setupFilters();
        this.setupSorters();
    }

    protected void setupFilters() {
        this.labelFilterator = new TextFilterator<T>(){

            public void getFilterStrings(List<String> addTo, T thing) {
                addTo.add(DefaultMatcherSearcher.this.labelStringifier.stringify(thing));
            }
        };
        this.labelEditor = new TextMatcherEditor(this.labelFilterator);
        this.prefixMatcher = new DefaultTermPrefixMatcher(this.labelStringifier);
        this.prefixEditor = new ChangeableMatcherEditor(this.prefixMatcher);
        BasicEventList matchersList = new BasicEventList();
        matchersList.add(this.labelEditor);
        matchersList.add(this.prefixEditor);
        this.primaryEditor = new CompositeMatcherEditor((EventList)matchersList);
        ((CompositeMatcherEditor)this.primaryEditor).setMode(24);
    }

    protected void setupSorters() {
        this.masterComparator = new SequentialComparator();
        this.prefixComp = new CountedPrefixComparator();
        this.labelComp = new StringComparator();
        this.masterComparator.addComparator(this.prefixComp);
        this.masterComparator.addComparator(this.labelComp);
    }

    public void setSearchString(String value) {
        this.prefixMatcher.setPrefixString(value);
        this.labelEditor.setFilterText(value.split(" "));
        this.prefixEditor.matcherChanged();
        this.prefixComp.setSearchString(value);
        this.sortedItems.setComparator(this.masterComparator);
    }

    public EventList<T> getResultingList() {
        return this.sortedItems;
    }

    public boolean isRestricted() {
        return this.prefixMatcher.getPrefixStringsToMatch().length != 0;
    }

    public void setSearchList(List<T> items) {
        this.filteredItems = new FilterList(GlazedLists.eventList(items), this.primaryEditor);
        this.sortedItems = new SortedList(this.filteredItems, this.masterComparator);
    }

    public void addMatcherEditorListener(MatcherEditor.Listener listener) {
        this.primaryEditor.addMatcherEditorListener(listener);
    }

    public int getResultCount() {
        return this.filteredItems.size();
    }
}

