/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.adjustments;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.searchers.adjustments.CombosAsDiscountSearcher;

public abstract class AbstractCombosAsDiscountCombobulator<T extends PersistentSummaryObject> {
    protected final CombosAsDiscountSearcher searcher = new CombosAsDiscountSearcher();
    protected T report;

    public final void setReport(T toSet) {
        this.report = toSet;
    }

    public final void combobulateReport() {
        if (this.report == null) {
            OrderMate.LOG.error("AbstractCombosAsDiscountCombobulator failed to combobulate, no target report was set!");
            return;
        }
        this.applySearchFilters();
        this.searcher.setComboDiscountType(CombosAsDiscountSearcher.ComboDiscountType.OpenPrice);
        List results = this.searcher.search();
        for (PriceReport result : results) {
            this.addToDiscountsTotal(result.getPrice());
            this.addToSalesExDiscountsTotal(result.getPrice());
        }
    }

    public abstract void applySearchFilters();

    public abstract void addToDiscountsTotal(Price var1);

    public abstract void addToSalesExDiscountsTotal(Price var1);
}

