/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.adjustments;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.reports.AccountTotalsReportQuery;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;

public class CombosAsDiscountSearcher
extends PropertySearcher<PriceReport> {
    private ComboDiscountType type;
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final IRangedQuerySearchFilter<Calendar> timeRangeFilter;

    public CombosAsDiscountSearcher() {
        this((ComboDiscountType)null);
    }

    public CombosAsDiscountSearcher(ComboDiscountType theType) {
        super(PriceReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.timeRangeFilter = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        ((TimeSearchFilter)this.timeRangeFilter).setInclusive(false);
        this.type = theType != null ? theType : ComboDiscountType.Adjustment;
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.timeRangeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        if (ComboDiscountType.Adjustment.equals((Object)this.type)) {
            return AccountTotalsReportQuery.getAdjustmentComboDiscounts();
        }
        return AccountTotalsReportQuery.getOpenPriceComboDiscounts("price");
    }

    public void setComboDiscountType(ComboDiscountType newType) {
        this.type = newType;
    }

    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Calendar> getTimeRangeFilter() {
        return this.timeRangeFilter;
    }

    public static enum ComboDiscountType {
        Adjustment,
        OpenPrice;

    }
}

