/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.adjustments;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.SimplePriceAdjustment;

public class PriceAdjustmentSearcher
extends PropertySearcher<SimplePriceAdjustment> {
    private ISingleValueSearchFilter adjustmentNameFilter;
    private ISingleValueSearchFilter adjustmentUnitFilter;
    private ISingleValueSearchFilter dollarAmountFilter;
    private ISingleValueSearchFilter percentageAmountFilter;
    private ISingleValueSearchFilter adjustmentLevelFilter;
    private ISingleValueSearchFilter directionFilter;

    public PriceAdjustmentSearcher() {
        super(SimplePriceAdjustment.class);
        this.adjustmentNameFilter = new TextSearchFilter(SimplePriceAdjustment.Properties.LABEL);
        this.adjustmentUnitFilter = new ObjectSearchFilter(TriggeredPriceAdjustment.Properties.UNIT);
        this.dollarAmountFilter = new TextSearchFilter(TriggeredPriceAdjustment.Properties.DOLLAR_AMOUNT);
        this.percentageAmountFilter = new TextSearchFilter(TriggeredPriceAdjustment.Properties.PERCENTAGE);
        this.adjustmentLevelFilter = new ObjectSearchFilter(TriggeredPriceAdjustment.Properties.LEVEL);
        this.directionFilter = new ObjectSearchFilter<PriceAdjustmentDirection>(InventoryPriceAdjustment.Properties.DIRECTION);
        this.addSearchFilter(this.adjustmentNameFilter);
        this.addSearchFilter(this.adjustmentUnitFilter);
        this.addSearchFilter(this.dollarAmountFilter);
        this.addSearchFilter(this.percentageAmountFilter);
        this.addSearchFilter(this.adjustmentLevelFilter);
        this.addSearchFilter(this.directionFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).active(TriggeredPriceAdjustment.class);
    }

    public ISingleValueSearchFilter getAdjustmentNameFilter() {
        return this.adjustmentNameFilter;
    }

    public ISingleValueSearchFilter getAdjustmentUnitFilter() {
        return this.adjustmentUnitFilter;
    }

    public ISingleValueSearchFilter getDollarAmountFilter() {
        return this.dollarAmountFilter;
    }

    public ISingleValueSearchFilter getPercentageAmountFilter() {
        return this.percentageAmountFilter;
    }

    public ISingleValueSearchFilter getAdjustmentLevelFilter() {
        return this.adjustmentLevelFilter;
    }

    public ISingleValueSearchFilter getDirectionFilter() {
        return this.directionFilter;
    }
}

