/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.delivery;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;

public class StreetDirectoryReferenceSearcher
extends PropertySearcher<StreetDirectoryReference> {
    private ISingleValueSearchFilter suburbFilter;
    private ISingleValueSearchFilter postCodeFilter;
    private ISingleValueSearchFilter streetNameFilter;
    private ISingleValueSearchFilter zoneFilter;

    public StreetDirectoryReferenceSearcher() {
        super(StreetDirectoryReference.class);
        this.suburbFilter = new TextSearchFilter(StreetDirectoryReference.Properties.SUBURB);
        this.postCodeFilter = new TextSearchFilter(StreetDirectoryReference.Properties.POSTCODE);
        this.streetNameFilter = new TextSearchFilter(StreetDirectoryReference.Properties.STREET_NAME);
        this.zoneFilter = new ObjectSearchFilter<DeliveryZone>(StreetDirectoryReference.Properties.ZONE);
        this.addSearchFilter(this.suburbFilter);
        this.addSearchFilter(this.postCodeFilter);
        this.addSearchFilter(this.streetNameFilter);
        this.addSearchFilter(this.zoneFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).orderBy(StreetDirectoryReference.Properties.SUBURB).orderBy(StreetDirectoryReference.Properties.STREET_NAME).active(StreetDirectoryReference.class);
    }

    public ISingleValueSearchFilter getSuburbFilter() {
        return this.suburbFilter;
    }

    public ISingleValueSearchFilter getPostCodeFilter() {
        return this.postCodeFilter;
    }

    public ISingleValueSearchFilter getStreetNameFilter() {
        return this.streetNameFilter;
    }

    public ISingleValueSearchFilter getZoneFilter() {
        return this.zoneFilter;
    }
}

