/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.ArrayList;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.users.User;

public class FinanceTransactionSearcher
extends PropertySearcher<FinanceTransaction> {
    private ObjectSearchFilter<String> systemStateFilter;
    private DateRangeSearchFilter tradingDayFilter;
    private RangeQuerySearchFilter<Integer> paidRangeFilter;
    private ObjectSearchFilter<String> referenceFilter;
    private ObjectSearchFilter<String> sourceFilter;
    private MultiOptionSearchFilter<FinanceUnit> unitFilter;
    private MultiOptionSearchFilter<Terminal> terminalFilter;
    private MultiOptionSearchFilter<CashDrawer> cashdrawerFilter;
    private MultiOptionSearchFilter<User> userFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private MultiOptionSearchFilter<VirtualEftpos> eftposFilter;
    private MultiOptionJoinSearchFilter<ConfigShift> shiftFilter;
    private MultiOptionJoinSearchFilter<FinanceUnit.FinanceUnitType> typeFilter;
    private MultiOptionJoinSearchFilter<AccountType> accountTypeFilter;

    public FinanceTransactionSearcher() {
        super(FinanceTransaction.class);
        this.systemStateFilter = new ObjectSearchFilter<String>(FinanceTransaction.Properties.SYSTEM_STATE);
        this.addSearchFilter(this.systemStateFilter);
        this.tradingDayFilter = new DateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.addSearchFilter(this.tradingDayFilter);
        this.paidRangeFilter = new RangeQuerySearchFilter(FinanceTransaction.Properties.PAID);
        this.addSearchFilter(this.paidRangeFilter);
        this.referenceFilter = new ObjectSearchFilter<String>(FinanceTransaction.Properties.TRANSACTION_REFERENCE);
        this.addSearchFilter(this.referenceFilter);
        this.sourceFilter = new ObjectSearchFilter<String>(FinanceTransaction.Properties.SOURCE);
        this.addSearchFilter(this.sourceFilter);
        this.shiftFilter = new MultiOptionJoinSearchFilter(FinanceTransaction.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT);
        this.addSearchFilter(this.shiftFilter);
        this.unitFilter = new MultiOptionSearchFilter<FinanceUnit>(FinanceTransaction.Properties.SUB_TYPE);
        this.addSearchFilter(this.unitFilter);
        this.terminalFilter = new MultiOptionSearchFilter<Terminal>(FinanceTransaction.Properties.TERMINAL);
        this.addSearchFilter(this.terminalFilter);
        this.cashdrawerFilter = new MultiOptionSearchFilter<CashDrawer>(FinanceTransaction.Properties.CASH_DRAWER);
        this.addSearchFilter(this.cashdrawerFilter);
        this.userFilter = new MultiOptionSearchFilter<User>(FinanceTransaction.Properties.USER);
        this.addSearchFilter(this.userFilter);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(FinanceTransaction.Properties.SALES_LOCATION);
        this.addSearchFilter(this.salesLocationFilter);
        this.eftposFilter = new MultiOptionSearchFilter<VirtualEftpos>(EftposTransaction.Properties.VIRTUAL_EFTPOS);
        this.typeFilter = new MultiOptionJoinSearchFilter(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.TYPE);
        this.addSearchFilter(this.typeFilter);
        this.accountTypeFilter = new MultiOptionJoinSearchFilter(FinanceTransaction.Properties.ACCOUNT, Account.Properties.ACCOUNT_TYPE);
        this.addSearchFilter(this.accountTypeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(FinanceTransaction.class);
        query.linkUsing(FinanceTransaction.Properties.SHIFT).linkUsing(FinanceTransaction.Properties.TRADING_DAY).orderBy(FinanceTransaction.Properties.SHIFT).orderBy(FinanceTransaction.Properties.CREATION_TIME);
        if (this.eftposFilter.hasSearchValue()) {
            ArrayList<Long> IDs = new ArrayList<Long>();
            for (VirtualEftpos eftpos : this.eftposFilter.getSelectedOptions()) {
                IDs.add(eftpos.getID());
            }
            query.whereIn("fk_config_virtual_eftpos", IDs);
        }
        return query;
    }

    @FilterConfig(dataType=String.class, nullAllowed=true, name="State", plural=FilterConfig.Plural.Single, sequence=5)
    public ObjectSearchFilter<String> getSystemStateFilter() {
        return this.systemStateFilter;
    }

    @FilterConfig(dataType=Date.class, nullAllowed=false, name="Date Range", plural=FilterConfig.Plural.Ranged, sequence=1)
    public DateRangeSearchFilter getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @FilterConfig(dataType=ConfigShift.class, nullAllowed=true, name="Shift", plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(dataType=String.class, nullAllowed=true, name="Reference #", plural=FilterConfig.Plural.Single, sequence=20)
    public ObjectSearchFilter<String> getReferenceFilter() {
        return this.referenceFilter;
    }

    @FilterConfig(dataType=FinanceUnit.FinanceUnitType.class, nullAllowed=true, name="Type", plural=FilterConfig.Plural.Multiple, sequence=30)
    public MultiOptionSearchFilter getTypeFilter() {
        return this.typeFilter;
    }

    @FilterConfig(dataType=FinanceUnit.class, nullAllowed=true, name="Payment Unit", plural=FilterConfig.Plural.Multiple, sequence=40)
    public MultiOptionSearchFilter getUnitFilter() {
        return this.unitFilter;
    }

    @FilterConfig(dataType=CashDrawer.class, nullAllowed=true, name="Cash Drawer", plural=FilterConfig.Plural.Multiple, sequence=50)
    public MultiOptionSearchFilter getCashdrawerFilter() {
        return this.cashdrawerFilter;
    }

    @FilterConfig(dataType=Terminal.class, nullAllowed=true, name="Terminal", plural=FilterConfig.Plural.Multiple, sequence=60)
    public MultiOptionSearchFilter getTerminalFilter() {
        return this.terminalFilter;
    }

    @FilterConfig(dataType=User.class, nullAllowed=true, name="User", plural=FilterConfig.Plural.Multiple, sequence=70)
    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    @FilterConfig(dataType=SalesLocation.class, nullAllowed=true, name="Sales Location", plural=FilterConfig.Plural.Multiple, sequence=90)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(dataType=VirtualEftpos.class, nullAllowed=true, name="Eftpos", plural=FilterConfig.Plural.Multiple, sequence=100)
    public MultiOptionSearchFilter getEftposFilter() {
        return this.eftposFilter;
    }

    @FilterConfig(dataType=AccountType.class, nullAllowed=true, name="Account Type", plural=FilterConfig.Plural.Multiple, sequence=110)
    public MultiOptionSearchFilter getAccountTypeFilter() {
        return this.accountTypeFilter;
    }

    @FilterConfig(dataType=String.class, nullAllowed=true, name="Source", plural=FilterConfig.Plural.Single, sequence=120)
    public ObjectSearchFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @FilterConfig(dataType=Integer.class, nullAllowed=true, name="Paid", plural=FilterConfig.Plural.Ranged, sequence=130)
    public RangeQuerySearchFilter<Integer> getPaidRangeFilter() {
        return this.paidRangeFilter;
    }
}

