/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.inventoryitem;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageAddLink;

public class InventoryAddSearcher
extends PropertySearcher<InventoryAdd> {
    private ISingleValueSearchFilter plusGroupFilter;
    private ISingleValueSearchFilter plusNameFilter;
    private ISingleValueSearchFilter<String> stockItemFilter;

    public InventoryAddSearcher() {
        super(InventoryAdd.class);
        this.plusGroupFilter = new ObjectSearchFilter<InventoryAddGroup>(InventoryAdd.Properties.ADD_GROUP);
        this.plusNameFilter = new TextSearchFilter(InventoryAdd.Properties.LABEL);
        this.stockItemFilter = new ObjectJoinSearchFilter<String>(new TextSearchFilter(StockItem.Properties.LABEL), InventoryAdd.Properties.STOCK_USAGE_LINKS, StockUsageAddLink.Properties.STOCK_ITEM);
        this.addSearchFilter(this.plusGroupFilter);
        this.addSearchFilter(this.plusNameFilter);
        this.addSearchFilter(this.stockItemFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).distinct().active(InventoryAdd.class).orderBy(InventoryAdd.Properties.ADD_GROUP);
    }

    public ISingleValueSearchFilter getPlusGroupFilter() {
        return this.plusGroupFilter;
    }

    public ISingleValueSearchFilter getPlusNameFilter() {
        return this.plusNameFilter;
    }

    public ISingleValueSearchFilter getStockItemFilter() {
        return this.stockItemFilter;
    }
}

