/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.inventoryitem;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;

public class InventoryComboSearcher
extends PropertySearcher<InventoryCombo> {
    private ISingleValueSearchFilter comboProfileFilter;
    private ISingleValueSearchFilter comboNameFilter;

    public InventoryComboSearcher() {
        super(InventoryCombo.class);
        this.comboProfileFilter = new ObjectSearchFilter<InventoryProfile>(InventoryCombo.Properties.PROFILE);
        this.comboNameFilter = new TextSearchFilter(InventoryCombo.Properties.LABEL);
        this.addSearchFilter(this.comboProfileFilter);
        this.addSearchFilter(this.comboNameFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).orderBy(InventoryCombo.Properties.PROFILE).wherePropertyIn(InventoryCombo.Properties.SYSTEM_STATE, new String[]{"ACTIVE", "INACTIVE"});
    }

    public ISingleValueSearchFilter getComboProfileFilter() {
        return this.comboProfileFilter;
    }

    public ISingleValueSearchFilter getComboNameFilter() {
        return this.comboNameFilter;
    }
}

