/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.GroupBy;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.finance.reports.AccountTotalsReportQuery;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class AccountTotalsReportSearcher
extends PropertySearcher<AccountTotalsReport> {
    private final IRangedQuerySearchFilter<Date> tradingDayDateFilter;
    private final ISingleValueSearchFilter<TradingDay> tradingDayFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final TimeSearchFilter timeFilter;
    private final MultiOptionSearchFilter salesLocationFilter;
    private final GroupBy groupBy;

    public AccountTotalsReportSearcher() {
        this(null, false);
    }

    public AccountTotalsReportSearcher(GroupBy groupByAccountProperty, boolean isSupportCrossDay) {
        super(AccountTotalsReport.class);
        this.tradingDayDateFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE), Account.Properties.SHIFT, Shift.Properties.TRADING_DAY);
        this.tradingDayFilter = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateFilter);
        this.timeFilter = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.groupBy = groupByAccountProperty;
        if (!isSupportCrossDay) {
            this.addSearchFilter(this.tradingDayDateRangeAdapter);
        } else {
            this.timeFilter.setSupportCrossDay(true);
        }
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return this.groupBy != null ? AccountTotalsReportQuery.getObjectQuery().groupBy(this.groupBy) : AccountTotalsReportQuery.getObjectQuery();
    }

    @FilterConfig(name="Date Range", nullAllowed=true, dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }

    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @FilterConfig(name="Time", nullAllowed=true, dateType=SQLDateType.TIME, dataType=Date.class, plural=FilterConfig.Plural.Ranged, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    @FilterConfig(name="Sales Location", nullAllowed=true, dataType=SalesLocation.class, plural=FilterConfig.Plural.Ranged, sequence=10)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

