/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.BooleanQueryFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.TotalsReportSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class CategoryReportSearcher
extends PropertySearcher<CategorySalesReport>
implements TradingDayFilteredReportSearcher<CategorySalesReport> {
    private final ObjectQuery query;
    private final IRangedQuerySearchFilter<Date> tradingDayRangeSearch;
    private final IRangedQuerySearchFilter<Date> tradingDayRangeSearchSIQ;
    private final ISingleValueSearchFilter<TradingDay> tradingDaySearch;
    private final ISingleValueSearchFilter<TradingDay> tradingDaySearchSIQ;
    private final ISingleValueSearchFilter<Boolean> keyCategoryFilter;
    private final ObjectSearchFilter<String> categoryName;
    private MultiOptionSearchFilter salesLocationFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private TotalsReportSearcher totalsReportSearcher;
    private boolean groupByTradingDay;
    private boolean groupByDayPart;
    private boolean tradingDayBySIQ;

    public CategoryReportSearcher() {
        super(CategorySalesReport.class);
        this.query = Query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("SUM(" + SalesItemQuantity.Properties.QUANTITY + " * " + SalesComponent.Properties.SAVED_UNIT_PRICE + ") AS sales_value ").selectFunc("SUM(" + SalesItemQuantity.Properties.QUANTITY + " * " + SalesComponent.Properties.PORTION + ") AS quantity_sold ").selectFunc("0 as mod_count").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY).orderBy(InventoryCategory.Properties.ID).groupBy(InventoryCategory.Properties.LABEL);
        this.tradingDayRangeSearch = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.tradingDayRangeSearchSIQ = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(SalesItemQuantity.Properties.TRADING_DAY);
        this.tradingDaySearch = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(Account.Properties.TRADING_DAY);
        this.tradingDaySearchSIQ = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(SalesItemQuantity.Properties.TRADING_DAY);
        this.keyCategoryFilter = new BooleanQueryFilter(InventoryCategory.Properties.KEY_CATEGORY);
        this.categoryName = new ObjectSearchFilter(InventoryCategory.Properties.LABEL);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayRangeSearch);
        this.tradingDayBySIQ = false;
        this.totalsReportSearcher = this.createTotalSearcher();
        this.totalsReportSearcher.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.categoryName);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.keyCategoryFilter);
    }

    public void setTradingDayBySIQ(boolean value) {
        this.tradingDayBySIQ = value;
        if (this.tradingDayBySIQ) {
            this.removeSearchFilter(this.tradingDaySearch);
            this.totalsReportSearcher.removeSearchFilter(this.tradingDaySearch);
            ((TradingDayDateRangeFilterAdapter)this.tradingDayDateRangeAdapter).setUnderlyingFilter(this.tradingDayRangeSearchSIQ);
            this.addSearchFilter(this.tradingDaySearchSIQ);
            this.totalsReportSearcher.addSearchFilter(this.tradingDaySearchSIQ);
        } else {
            this.removeSearchFilter(this.tradingDaySearchSIQ);
            this.totalsReportSearcher.removeSearchFilter(this.tradingDaySearchSIQ);
            this.totalsReportSearcher.removeSearchFilter(this.tradingDayRangeSearchSIQ);
            ((TradingDayDateRangeFilterAdapter)this.tradingDayDateRangeAdapter).setUnderlyingFilter(this.tradingDayRangeSearch);
            this.addSearchFilter(this.tradingDaySearch);
            this.totalsReportSearcher.addSearchFilter(this.tradingDaySearch);
        }
        this.totalsReportSearcher.setTradingDayBySIQ(value);
    }

    protected void setTotalsReportSearcher(TotalsReportSearcher searcher) {
        this.totalsReportSearcher = searcher;
        this.totalsReportSearcher.addSearchFilter(this.tradingDayRangeSearch);
        this.totalsReportSearcher.addSearchFilter(this.tradingDaySearch);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return this.query.copy();
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery realisedQuery = super.getObjectQuery();
        if (this.groupByTradingDay) {
            if (this.tradingDayBySIQ) {
                realisedQuery.select(SalesItemQuantity.Properties.TRADING_DAY).groupBy(SalesItemQuantity.Properties.TRADING_DAY).orderBy(SalesItemQuantity.Properties.TRADING_DAY);
                if (this.groupByDayPart) {
                    realisedQuery.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
                    realisedQuery.groupBy("fk_config_day_part");
                } else {
                    realisedQuery.selectFunc("NULL as fk_config_day_part");
                }
                this.salesLocationFilter.addQueryRestriction(realisedQuery);
            } else {
                realisedQuery.selectFunc("NULL as fk_config_day_part");
                realisedQuery.select(Account.Properties.TRADING_DAY).groupBy(Account.Properties.TRADING_DAY).orderBy(Account.Properties.TRADING_DAY);
            }
        } else {
            realisedQuery.selectFunc("NULL as fk_finance_trading_day");
            realisedQuery.selectFunc("NULL as fk_config_day_part");
        }
        return realisedQuery;
    }

    @Override
    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayRangeSearch;
    }

    @Override
    public List<CategorySalesReport> search() {
        List<CategorySalesReport> resultList = super.search();
        return this.fillOutTotals(resultList);
    }

    public void groupByTradingDay(boolean value) {
        this.groupByTradingDay = value;
    }

    public void groupByDayPart(boolean value) {
        this.groupByDayPart = value;
    }

    protected List<CategorySalesReport> fillOutTotals(List<CategorySalesReport> reportList) {
        List totals = this.totalsReportSearcher.search();
        if (totals.size() == 1) {
            TotalsReport total = (TotalsReport)totals.get(0);
            for (CategorySalesReport reportItem : reportList) {
                reportItem.setTotalSales(total != null ? total.getTotal() : Price.ZERO_DOLLAR);
            }
        } else if (totals.size() > 1) {
            throw new IllegalStateException("Should only have found one totals result");
        }
        return reportList;
    }

    protected TotalsReportSearcher<? extends TotalsReport> createTotalSearcher() {
        return new TotalsReportSearcher(this.getTradingDayDateRangeFilter());
    }

    public TotalsReportSearcher getTotalSearcher() {
        return this.totalsReportSearcher;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearch;
    }

    @FilterConfig(name="Category Like", plural=FilterConfig.Plural.Single, dataType=String.class, nullAllowed=true, priority=true, sequence=4)
    public ISingleValueSearchFilter<String> getCategoryNameFilter() {
        return this.categoryName;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    public ISingleValueSearchFilter<Boolean> getKeyCategoryFilter() {
        return this.keyCategoryFilter;
    }

    public List<InventoryCategory> getKeyCategoryNames() {
        return PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).equals(InventoryCategory.Properties.KEY_CATEGORY, "1").toString(), null);
    }

    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

