/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.reports.CoversReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.tables.LogicalTable;
import org.apache.commons.lang.NotImplementedException;

public class CoversReportSearcher
extends PropertySearcher<CoversReport>
implements TradingDayFilteredReportSearcher<CoversReport> {
    private ObjectQuery tableQuery;
    private ObjectQuery otherQuery;
    private String groupBy = null;
    private static final String GROUP_BY_DOW = "DAYOFWEEK(" + TradingDay.Properties.DATE + ")";
    private static final String GROUP_BY_WEEK = "YEARWEEK(" + TradingDay.Properties.DATE + ", 7)";
    private static final String GROUP_BY_MONTH = "MONTH(" + TradingDay.Properties.DATE + "), YEAR(" + TradingDay.Properties.DATE + ")";
    private final ObjectJoinSearchFilter<TradingDay> tradingDaySearch;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearch;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final ObjectSearchFilter<Customer> customerSearch;
    private final ObjectJoinSearchFilter<CustomerCategory> customerCategorySearch;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private SingleValueSearchFilter<CoversReportPeriodType> periodFilter;
    private final TimeSearchFilter timeSearchFilter;

    public CoversReportPeriodType getPeriodType() {
        return CoversReportPeriodType.getCoversReportPeriodType(this.groupBy);
    }

    public CoversReportSearcher() {
        super(CoversReport.class);
        this.tradingDaySearch = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{SalesItem.Properties.ACCOUNT}, new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY));
        this.tradingDayDateRangeSearch = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeSearch);
        this.customerSearch = new ObjectSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.customerCategorySearch = new ObjectJoinSearchFilter<CustomerCategory>(new PropertiedObject.Property[]{Account.Properties.CUSTOMER}, new ObjectSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY));
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.periodFilter = new ObjectSearchFilter<CoversReportPeriodType>(null);
        this.timeSearchFilter = new TimeSearchFilter(Account.Properties.CREATION_DATE_TIME);
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            this.otherQuery = CoversReportSearcher.getOtherAccountsQueryWithoutGroupBy();
        }
        this.tableQuery = CoversReportSearcher.getTableQueryWithoutGroupBy();
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.customerSearch);
        this.addSearchFilter(this.customerCategorySearch);
        this.addSearchFilter(this.timeSearchFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    public void initWebSearchFilter() {
        if (this.periodFilter.hasSearchValue()) {
            this.groupBy = this.periodFilter.getSearchValue().getGroupBy();
        }
    }

    @Override
    public ObjectQuery getBaseQuery() {
        throw new NotImplementedException("Not implemented. Call getObjectQuery.");
    }

    @Override
    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateRangeSearch;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearch;
    }

    @FilterConfig(name="Customer", dataType=Customer.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, makerName="Customer Details")
    public ObjectSearchFilter<Customer> getCustomerFilter() {
        return this.customerSearch;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(name="Customer Category", dataType=CustomerCategory.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=4)
    public ISingleValueSearchFilter<CustomerCategory> getCustomerCategoryFilter() {
        return this.customerCategorySearch;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public TimeSearchFilter getTimeSearchFilter() {
        return this.timeSearchFilter;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @FilterConfig(name="Period", defaultValue="DAILY", dataType=CoversReportPeriodType.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=3)
    public ISingleValueSearchFilter<CoversReportPeriodType> getPeriodFilter() {
        return this.periodFilter;
    }

    public CoversReportSearcher groupByDayOfWeek() {
        this.groupBy = GROUP_BY_DOW;
        return this;
    }

    public CoversReportSearcher groupByWeek() {
        this.groupBy = GROUP_BY_WEEK;
        return this;
    }

    public CoversReportSearcher groupByMonth() {
        this.groupBy = GROUP_BY_MONTH;
        return this;
    }

    private static ObjectQuery getTableQueryWithoutGroupBy() {
        return Query.select(TableAccount.Properties.TRADING_DAY, "fk_finance_trading_day").selectFunc("null as fk_config_day_part").selectFunc("sales_account.fk_finance_trading_day * 31 + config_table_group.ID AS ID").select(Account.Properties.ACCOUNT_TYPE, "account_type").selectFunc("concat('Table Section ', config_table_group.name) as 'section'").sum(Account.Properties.NUM_PATRONS, "total_covers").sum(Account.Properties.SAVED_TOTAL, "total_sales").equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.CLOSED).equals(Account.Properties.ACCOUNT_TYPE, TableAccount.TYPE).linkUsing(Account.Properties.TRADING_DAY).linkUsing(TableAccount.Properties.TABLE).linkUsing(LogicalTable.Properties.TABLE_GROUP);
    }

    private static ObjectQuery getOtherAccountsQueryWithoutGroupBy() {
        return Query.select(Account.Properties.TRADING_DAY, "fk_finance_trading_day").selectFunc("null as fk_config_day_part").selectFunc("sales_account.fk_finance_trading_day * 31 + sales_account.account_type AS ID").select(Account.Properties.ACCOUNT_TYPE, "account_type").select("", "section").sum(Account.Properties.NUM_PATRONS, "total_covers").sum(Account.Properties.SAVED_TOTAL, "total_sales").equals(Account.Properties.ACCOUNT_STATE, "CLOSED").not().equals(Account.Properties.ACCOUNT_TYPE, TableAccount.TYPE).linkUsing(Account.Properties.TRADING_DAY);
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery localQuery = this.tableQuery.copy();
        this.applyGrouping(localQuery, true);
        localQuery = this.addSearchFilterRestrictions(localQuery);
        if (this.otherQuery != null) {
            ObjectQuery localOtherQuery = this.otherQuery.copy();
            this.applyGrouping(localOtherQuery, false);
            localOtherQuery = this.addSearchFilterRestrictions(localOtherQuery);
            localQuery = localQuery.union(localOtherQuery);
            this.applyOrdering(localQuery);
        }
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug(this.getClass().getSimpleName() + " query: " + localQuery.copy());
        }
        return localQuery;
    }

    private void applyGrouping(ObjectQuery query, boolean isTableQuery) {
        if (this.groupBy == null) {
            query.groupBy(TableAccount.Properties.TRADING_DAY);
        } else {
            query.groupBy(this.groupBy);
        }
        if (isTableQuery) {
            query.groupBy("section");
        } else {
            query.groupBy("account_type");
        }
    }

    private void applyOrdering(ObjectQuery query) {
        if (this.groupBy != null && this.groupBy.startsWith("DAYOFWEEK")) {
            query.orderBy("DAYOFWEEK(trading_day_name)", false);
        } else {
            query.orderBy("fk_finance_trading_day", false);
        }
        query.orderBy("account_type", true);
    }

    static /* synthetic */ String access$000() {
        return GROUP_BY_DOW;
    }

    static /* synthetic */ String access$100() {
        return GROUP_BY_WEEK;
    }

    static /* synthetic */ String access$200() {
        return GROUP_BY_MONTH;
    }

    public static enum CoversReportPeriodType {
        DAILY("Daily", null, "Date", CoversReport.Properties.TRADING_DAY_STRING),
        DAY_OF_WEEK("Day Of Week", CoversReportSearcher.access$000(), "Day Of Week", CoversReport.Properties.DAY_OF_WEEK),
        WEEKLY("Weekly", CoversReportSearcher.access$100(), "Week Ending", CoversReport.Properties.WEEK_ENDING),
        MONTHLY("Monthly", CoversReportSearcher.access$200(), "Month", CoversReport.Properties.MONTH);

        private String desc;
        private String groupByStr;
        private String firstColName;
        private PropertiedObject.Property property;

        private CoversReportPeriodType(String desc, String groupByStr, String firstColName, PropertiedObject.Property property) {
            this.desc = desc;
            this.groupByStr = groupByStr;
            this.firstColName = firstColName;
            this.property = property;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getGroupBy() {
            return this.groupByStr;
        }

        public String getFirstColName() {
            return this.firstColName;
        }

        public PropertiedObject.Property getProperty() {
            return this.property;
        }

        public String toString() {
            return this.desc;
        }

        public static CoversReportPeriodType getCoversReportPeriodType(String groupBy) {
            for (CoversReportPeriodType period : CoversReportPeriodType.values()) {
                if (groupBy == null || !groupBy.equals(period.groupByStr)) continue;
                return period;
            }
            return DAILY;
        }
    }
}

