/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.Between;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.reports.DebtorTransactionSummaryReport;

public class DebtorTransactionSummaryReportSearcher
extends PropertySearcher<DebtorTransactionSummaryReport> {
    private final DateRangeSearchFilter debtorTransactionDateRangeSearch;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter debtorGroupSearchFilter;
    private final TextSearchFilter debtorNameSearchFilter;

    public DebtorTransactionSummaryReportSearcher() {
        super(DebtorTransactionSummaryReport.class);
        this.debtorTransactionDateRangeSearch = new OptimisedDateRangeSearchFilter(DebtorSale.Properties.SALE_DATE, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.debtorTransactionDateRangeSearch);
        this.debtorGroupSearchFilter = new MultiOptionSearchFilter<DebtorGroup>(AbstractDebtor.Properties.GROUP);
        this.debtorNameSearchFilter = new TextSearchFilter(AbstractDebtor.Properties.LABEL);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.debtorNameSearchFilter);
    }

    public String getSQLString() {
        return "SELECT debtor.ID\n\t,debtor.NAME AS NAME\n\t,debtor.FK_debtor_group AS debtor_group\n\t,COALESCE(salesResults.sales_inc_tax, 0.0) AS sales_inc_tax\n\t,COALESCE(paymentResults.payments, 0.0) AS payments\n\t,(COALESCE(salesResults.sales_inc_tax, 0.0) - COALESCE(paymentResults.payments, 0.0)) AS balance\n\t,COALESCE(salesResults.cost_total, 0.0) AS cost_total\n\t,COALESCE(salesResults.tax, 0.0) AS tax\nFROM debtor\nLEFT JOIN (\n\tSELECT debtor_sale.FK_Debtor AS debtorID\n\t\t,SUM(debtor_sale.total) AS sales_inc_tax\n\t\t,SUM(salesAccTotal.COGS) AS cost_total\n\t\t,SUM(salesAccTotal.tax) AS tax\n\tFROM debtor_sale\n\t\t,(\n\t\t\tSELECT innerSalesAcc.fk_sales_account AS fk_sales_account\n\t\t\t\t,SUM(total) AS total\n\t\t\t\t,SUM(tax) AS tax\n\t\t\t\t,SUM(COGS) AS COGS\n\t\t\tFROM (\n\t\t\t\tSELECT sales_item.FK_sales_account AS fk_sales_account\n\t\t\t\t\t,SUM(sales_component.saved_total_price * (debtor_sale.total / sales_account.saved_total)) AS total\n\t\t\t\t\t,SUM(sales_component.saved_total_tax * (debtor_sale.total / sales_account.saved_total)) AS tax\n\t\t\t\t\t,SUM(sales_component.saved_total_cost * (debtor_sale.total / sales_account.saved_total)) AS COGS\n\t\t\t\tFROM debtor_sale\n\t\t\t\tINNER JOIN sales_account ON debtor_sale.fk_sales_account = sales_account.ID\n\t\t\t\tINNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID\n\t\t\t\tINNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID\n" + this.checkForWhereClause(true, Arrays.asList(this.debtorTransactionDateRangeSearch), "sale_date", "debtor_sale") + "\n\t\t\t\tGROUP BY sales_item.ID\n\t\t\t\t) AS innerSalesAcc\n\t\t\tGROUP BY innerSalesAcc.fk_sales_account\n\t\t\t) AS salesAccTotal\n\tWHERE debtor_sale.FK_sales_account = salesAccTotal.fk_sales_account\n\tGROUP BY debtor_sale.FK_Debtor\n\t) AS salesResults ON salesResults.debtorID = debtor.ID\nLEFT JOIN (\n\tSELECT debtor_payment.FK_Debtor AS debtorID\n\t\t,SUM(debtor_payment.amount) AS payments\n\tFROM debtor_payment, finance_transaction\n\tWHERE debtor_payment.FK_finance_transaction = finance_transaction.ID\n" + this.checkForWhereClause(false, Arrays.asList(this.debtorTransactionDateRangeSearch), "timestamp", "finance_transaction") + "\n\tGROUP BY debtor_payment.FK_Debtor\n\t) AS paymentResults ON paymentResults.debtorID = debtor.ID\nWHERE (\n\t\tsalesResults.sales_inc_tax IS NOT NULL\n\t\tOR paymentResults.payments IS NOT NULL\n\t\t)\n" + this.checkForWhereClause(false, Arrays.asList(this.debtorNameSearchFilter, this.debtorGroupSearchFilter), "", "") + "\nORDER BY debtor_group, NAME";
    }

    private String checkForWhereClause(boolean checkToAddWhereClause, List<QuerySearchFilter> asList, String dateRangeColumn, String dateRangeTable) {
        if (!this.checkForActiveFilters(asList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(checkToAddWhereClause ? "WHERE " : "AND ");
        if (this.debtorTransactionDateRangeSearch.hasSearchValue() && asList.contains(this.debtorTransactionDateRangeSearch)) {
            this.appendDateRangeCondition(sb, dateRangeColumn, dateRangeTable);
        }
        if (this.debtorGroupSearchFilter.hasSearchValue() && asList.contains(this.debtorGroupSearchFilter)) {
            this.appendMultiSelectDebtorGroupCondition(sb);
        }
        if (this.debtorNameSearchFilter.hasSearchValue() && asList.contains(this.debtorNameSearchFilter)) {
            this.appendNameSearchCondition(sb);
        }
        sb.delete(sb.length() - 5, sb.length());
        return sb.toString();
    }

    private boolean checkForActiveFilters(List<QuerySearchFilter> asList) {
        boolean checkToBuild = false;
        for (QuerySearchFilter searchFilter : asList) {
            checkToBuild |= searchFilter.hasSearchValue();
        }
        return checkToBuild;
    }

    private void appendDateRangeCondition(StringBuilder sb, final String dateRangeColumn, final String dateRangeTable) {
        sb.append(new Between(this.tradingDayDateRangeAdapter.getProperty(), ObjectQuery.convertToSQLType(this.getTradingDayStartDateTime(), this.debtorTransactionDateRangeSearch.getDateType()), ObjectQuery.convertToSQLType(this.getTradingDayEndDateTime(), this.debtorTransactionDateRangeSearch.getDateType())){

            @Override
            protected String getColumn() {
                return dateRangeColumn;
            }

            @Override
            protected String getTable() {
                return dateRangeTable;
            }
        }.toString());
        sb.append(" AND\n");
    }

    private Date getTradingDayStartDateTime() {
        return (Date)this.tradingDayDateRangeAdapter.getStart();
    }

    private Date getTradingDayEndDateTime() {
        Date toReturn = (Date)this.tradingDayDateRangeAdapter.getEnd();
        if (toReturn == null) {
            toReturn = new Date();
        }
        return toReturn;
    }

    private void appendMultiSelectDebtorGroupCondition(StringBuilder sb) {
        if (this.debtorGroupSearchFilter.getSelectedCount() > 1) {
            sb.append("debtor").append(".").append("FK_debtor_group").append(" ");
            sb.append("IN").append(" ");
            Iterator<Long> it = this.getIDValues(this.debtorGroupSearchFilter.getSelectedOptions()).iterator();
            sb.append("(").append(it.next());
            while (it.hasNext()) {
                sb.append(",").append(it.next());
            }
            sb.append(")");
        } else {
            sb.append("debtor").append(".").append("FK_debtor_group").append(" ");
            sb.append("=").append(" ").append(this.getIDValues(this.debtorGroupSearchFilter.getSelectedOptions()).get(0));
        }
        sb.append(" AND\n");
    }

    private void appendNameSearchCondition(StringBuilder sb) {
        sb.append("debtor").append(".").append("name").append(" ").append("LIKE").append(" ").append("'%").append(this.debtorNameSearchFilter.getSearchValue()).append("%'");
        sb.append(" AND\n");
    }

    private List<Long> getIDValues(List selectedOptions) {
        ArrayList<Long> toReturn = new ArrayList<Long>();
        for (Object obj : selectedOptions) {
            if (!(obj instanceof PersistentObject)) continue;
            toReturn.add(((PersistentObject)obj).getID());
        }
        return toReturn;
    }

    @Override
    public List<DebtorTransactionSummaryReport> search() {
        return PersistenceManager.getObjectList(this.getPersistentClass(), this.getSQLString(), null);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public DateRangeSearchFilter getDebtorTransactionDateRangeSearch() {
        return this.debtorTransactionDateRangeSearch;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Debtor Group", dataType=DebtorGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=3)
    public MultiOptionSearchFilter getDebtorGroupSearchFilter() {
        this.addSearchFilter(this.debtorGroupSearchFilter);
        return this.debtorGroupSearchFilter;
    }

    @FilterConfig(name="Debtor Name Like", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public TextSearchFilter getDebtorNameSearchFilter() {
        return this.debtorNameSearchFilter;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return null;
    }
}

