/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.users.User;

public class EventSearcher
extends PropertySearcher<EventLogRecord> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private TimeSearchFilter timeRangeFilter;
    private MultiOptionSearchFilter terminalFilter;
    private MultiOptionSearchFilter userFilter;
    private MultiOptionSearchFilter eventTypeFilter;
    private TextSearchFilter eventLogTextFilter;
    private MultiOptionSearchFilter shiftFilter;

    public EventSearcher() {
        super(EventLogRecord.class);
        this.dateRangeFilter = new DateRangeSearchFilter(EventLogRecord.Properties.EVENT_DATE, SQLDateType.DATE);
        this.timeRangeFilter = new TimeSearchFilter(EventLogRecord.Properties.EVENT_TIME);
        this.terminalFilter = new MultiOptionSearchFilter<Terminal>(EventLogRecord.Properties.TERMINAL);
        this.userFilter = new MultiOptionSearchFilter<User>(EventLogRecord.Properties.USER);
        this.eventTypeFilter = new MultiOptionSearchFilter<String>(EventLogRecord.Properties.TYPE);
        this.eventLogTextFilter = new TextSearchFilter(EventLogRecord.Properties.MESSAGE);
        this.shiftFilter = new MultiOptionSearchFilter<Shift>(EventLogRecord.Properties.SHIFT);
        this.addSearchFilter(this.dateRangeFilter);
        this.addSearchFilter(this.timeRangeFilter);
        this.addSearchFilter(this.terminalFilter);
        this.addSearchFilter(this.userFilter);
        this.addSearchFilter(this.eventLogTextFilter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.eventTypeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass());
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public TimeSearchFilter getTimeRangeFilter() {
        return this.timeRangeFilter;
    }

    @FilterConfig(name="Terminal", dataType=Terminal.class, plural=FilterConfig.Plural.Multiple, priority=false, sequence=5)
    public MultiOptionSearchFilter getTerminalFilter() {
        return this.terminalFilter;
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, order="FirstName, Surname", priority=true, sequence=4)
    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    public MultiOptionSearchFilter getEventTypeFilter() {
        return this.eventTypeFilter;
    }

    @FilterConfig(name="Contains", dataType=String.class, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public ISingleValueSearchFilter getEventLogTextFilter() {
        return this.eventLogTextFilter;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=6)
    public MultiOptionSearchFilter getShiftFilter() {
        return this.shiftFilter;
    }
}

