/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.SearchHelper;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.reports.kts.KTSReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class KTSReportSearcher
extends PropertySearcher<KTSReport> {
    private final IRangedQuerySearchFilter<Date> dateRangeSearchFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter ktsSearchFilter;
    private final TimeSearchFilter timeFilter;
    private MultiOptionJoinSearchFilter<SalesLocation> salesLocationFilter;
    private PeriodReportAdapter periodAdapter;

    public KTSReportSearcher(PeriodReportAdapter period) {
        super(KTSReport.class);
        this.dateRangeSearchFilter = new OptimisedDateRangeSearchFilter(KTSDocketData.Properties.CREATED, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeSearchFilter);
        this.ktsSearchFilter = new MultiOptionSearchFilter(KTSDocketPrinter.Properties.ID);
        this.timeFilter = new TimeSearchFilter(KTSDocketData.Properties.CREATED);
        this.salesLocationFilter = new MultiOptionJoinSearchFilter(KTSDocketData.Properties.SALES_ACCOUNT, Account.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.ktsSearchFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.periodAdapter = period;
    }

    public void setKTSs(Collection listOfKTSs) {
        this.ktsSearchFilter.setSearchOptions(listOfKTSs);
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeSearchFilter;
    }

    @FilterConfig(name="TPX", dataType=KTSDocketPrinter.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=3)
    public MultiOptionSearchFilter getKTSSearchFilter() {
        return this.ktsSearchFilter;
    }

    @FilterConfig(name="Time", dateType=SQLDateType.TIME, dataType=Date.class, plural=FilterConfig.Plural.Ranged, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(KTSDocketData.Properties.CREATED).select(KTSDocketData.Properties.TIME_LIVE, "time_live").select(KTSDocketData.Properties.SALES_ACCOUNT, "fk_sales_account").select(KTSDocketPrinter.Properties.LABEL, "kts_name").whereFunction("time_live>='0'").linkUsing(KTSDocketData.Properties.PRINTER, KTSDocketPrinter.Properties.ID);
        return oQuery;
    }

    @Override
    public List<KTSReport> search() {
        SearchHelper.setWidestDateRange(this.getDateRangeFilter(), this.getPeriod());
        return super.search();
    }

    public PeriodReportAdapter getPeriod() {
        return this.periodAdapter;
    }
}

