/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.sales.Customer;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;

public class LoyaltyPointsSearcher
extends PropertySearcher<LoyaltyPointTransaction> {
    private ISingleValueSearchFilter firstNameFilter;
    private ISingleValueSearchFilter lastNameFilter;
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private TimeSearchFilter timeFilter;

    public LoyaltyPointsSearcher() {
        super(LoyaltyPointTransaction.class);
        this.firstNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{LoyaltyPointTransaction.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.FIRST_NAME));
        this.lastNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{LoyaltyPointTransaction.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.LAST_NAME));
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(LoyaltyPointTransaction.Properties.DATETIME, SQLDateType.TIMESTAMP);
        this.timeFilter = new TimeSearchFilter(LoyaltyPointTransaction.Properties.DATETIME);
        this.addSearchFilter(this.firstNameFilter);
        this.addSearchFilter(this.lastNameFilter);
        this.addSearchFilter(this.dateRangeFilter);
        this.addSearchFilter(this.timeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).orderBy(LoyaltyPointTransaction.Properties.CUSTOMER).orderBy(LoyaltyPointTransaction.Properties.DATETIME).active(LoyaltyPointTransaction.class);
    }

    public ISingleValueSearchFilter getFirstNameFilter() {
        return this.firstNameFilter;
    }

    public ISingleValueSearchFilter getLastNameFilter() {
        return this.lastNameFilter;
    }

    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }
}

