/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Collection;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.RefundsReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class RefundsReportSearcher
extends PropertySearcher<RefundsReport>
implements TradingDayFilteredReportSearcher<RefundsReport> {
    private final ISingleValueSearchFilter<TradingDay> tradingDaySearchFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearchFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter userSearchFilter;
    private final TimeSearchFilter timeFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;
    private ObjectSearchFilter<PeriodReportAdapter.PeriodAndDateRange> periodFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private PeriodReportAdapter periodAdapter;

    public RefundsReportSearcher(PeriodReportAdapter period) {
        super(RefundsReport.class);
        this.tradingDaySearchFilter = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearchFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeSearchFilter);
        this.userSearchFilter = new MultiOptionSearchFilter<User>(SalesItemQuantity.Properties.USER);
        this.timeFilter = new TimeSearchFilter(Account.Properties.CREATION_DATE_TIME);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.tradingDayDateRangeSearchFilter, null);
        this.periodFilter = new ObjectSearchFilter(null);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDaySearchFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.userSearchFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.periodAdapter = period;
    }

    public void setDateRange(Date firstDate, Date secondDate) {
        if (firstDate.compareTo(secondDate) > 0) {
            this.tradingDayDateRangeSearchFilter.setStart(secondDate);
            this.tradingDayDateRangeSearchFilter.setEnd(firstDate);
        } else {
            this.tradingDayDateRangeSearchFilter.setStart(firstDate);
            this.tradingDayDateRangeSearchFilter.setEnd(secondDate);
        }
    }

    public void setStartDate(Date value) {
        this.tradingDayDateRangeSearchFilter.setStart(value);
    }

    public void setEndDate(Date value) {
        this.tradingDayDateRangeSearchFilter.setEnd(value);
    }

    public void setUsers(Collection listOfUsers) {
        this.userSearchFilter.setSearchOptions(listOfUsers);
    }

    @Override
    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1, filterLink="Period")
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateRangeSearchFilter;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearchFilter;
    }

    @FilterConfig(name="Period", defaultValue="Daily", dataType=PeriodReportAdapter.PeriodAndDateRange.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=2, filterLink="Date Range")
    public ISingleValueSearchFilter<PeriodReportAdapter.PeriodAndDateRange> getPeriodFilter() {
        return this.periodFilter;
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=3)
    public MultiOptionSearchFilter getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    @Override
    public String getDisplayableDate() {
        PeriodReportAdapter period = this.getPeriod();
        if (period != null) {
            if (this.getTradingDayDateRangeFilter().hasSearchValue()) {
                return period.formatDateForDisplay((Date)this.getTradingDayDateRangeFilter().getStart());
            }
            if (this.getTradingDayFilter().hasSearchValue()) {
                return period.formatDateForDisplay(this.getTradingDayFilter().getSearchValue().getDate());
            }
        }
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(SalesItemQuantity.Properties.ID, "id").select(Account.Properties.CREATION_DATE_TIME, "creation_time").select(SalesItem.Properties.ID, "fk_sales_item").select(User.Properties.ID, "fk_config_user").select(InventoryItemPortion.Properties.LABEL, "portion_label").select(InventoryItem.Properties.LABEL, "item_name").select(InventoryItemSize.Properties.LABEL, "item_size").select(SalesComponent.Properties.SAVED_UNIT_PRICE, "unit_price").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").linkUsing(SalesItemQuantity.Properties.USER, User.Properties.ID).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(InventoryItemUnit.Properties.PORTION, InventoryItemPortion.Properties.ID).linkUsing(InventoryItemUnit.Properties.SIZE, InventoryItemSize.Properties.ID).whereFunction("sales_item_quantity.item_state IN ('REFUNDED', 'REFUNDED_WASTED')").groupBy(SalesItemQuantity.Properties.ID).orderBy(User.Properties.ID).orderBy(Account.Properties.CREATION_DATE_TIME);
        return oQuery;
    }

    public PeriodReportAdapter getPeriod() {
        PeriodReportAdapter period = this.periodAdapter;
        if (period == null && this.periodFilter.hasSearchValue()) {
            period = ((PeriodReportAdapter.PeriodAndDateRange)((Object)this.periodFilter.getSearchValue())).getPeriod();
        }
        return period;
    }
}

