/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class TotalsReportSearcher<T extends TotalsReport>
extends PropertySearcher<T> {
    final ObjectQuery query;
    private final IRangedQuerySearchFilter<Date> tradingDayRangeFilter;
    private final IRangedQuerySearchFilter<Date> salesDateTimeRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private boolean tradingDayBySIQ;
    private boolean groupByDayPart;
    private MultiOptionSearchFilter salesLocationFilter;

    public TotalsReportSearcher() {
        this(TotalsReport.class);
    }

    protected TotalsReportSearcher(Class clazz) {
        this(clazz, new RangeJoinSearchFilter<Date>(new PropertiedObject.Property[]{Account.Properties.TRADING_DAY}, new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP)));
    }

    public TotalsReportSearcher(IRangedQuerySearchFilter<Date> tradingDayFilter) {
        this(TotalsReport.class, tradingDayFilter);
    }

    protected TotalsReportSearcher(Class clazz, IRangedQuerySearchFilter<Date> tradingDayFilter) {
        super(clazz);
        this.query = Query.selectFunc("MAX(sales_component.ID) as ID").selectFunc("SUM(" + SalesComponent.Properties.SAVED_UNIT_PRICE + " * " + SalesItemQuantity.Properties.QUANTITY + ") AS total ").selectFunc("SUM(" + SalesComponent.Properties.UNIT_TAX_AMOUNT + " * " + SalesItemQuantity.Properties.QUANTITY + ") AS total_tax ").selectFunc("COUNT(DISTINCT " + SalesItem.Properties.ACCOUNT + ") AS count").selectFunc("NULL as 'total_date'").select(SalesItemQuantity.Properties.SALES_LOCATION, "fk_config_sales_location").selectFunc("0 as mod_count").linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT);
        this.salesDateTimeRangeFilter = new OptimisedDateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayBySIQ = false;
        this.groupByDayPart = false;
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.tradingDayRangeFilter = tradingDayFilter;
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(tradingDayFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery theQuery = this.query.copy();
        if (this.tradingDayBySIQ) {
            theQuery.linkUsing(SalesItemQuantity.Properties.TRADING_DAY);
            if (this.salesLocationFilter.hasSearchValue()) {
                this.salesLocationFilter.addQueryRestriction(theQuery);
            }
            if (this.groupByDayPart) {
                theQuery.groupBy(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
            } else {
                theQuery.selectFunc("null as fk_config_day_part");
            }
        } else {
            theQuery.linkUsing(Account.Properties.TRADING_DAY).selectFunc("null as fk_config_day_part");
        }
        return theQuery;
    }

    public final IRangedQuerySearchFilter<Date> getTradingDayRangeFilter() {
        return this.tradingDayRangeFilter;
    }

    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    public IRangedQuerySearchFilter<Date> getSalesDateTimeRangeFilter() {
        this.addSearchFilter(this.salesDateTimeRangeFilter);
        return this.salesDateTimeRangeFilter;
    }

    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public void setGroupByDayPart(boolean value) {
    }

    public void setTradingDayBySIQ(boolean value) {
        this.tradingDayBySIQ = value;
    }
}

