/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.misc.TradingDay;

public interface TradingDayFilteredReportSearcher<T extends PersistentObjectI>
extends ObjectQuerySearcher<T> {
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter();

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter();

    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter();

    public String getDisplayableDate();

    public static class DisplayHelper {
        public static String getDisplayableDate(TradingDayFilteredReportSearcher searcher) {
            if (searcher.getTradingDayFilter().hasSearchValue()) {
                TradingDay day = searcher.getTradingDayFilter().getSearchValue();
                Date closeTime = day.getCloseDateTime();
                String closeTimeDescription = "";
                if (closeTime == null) {
                    closeTime = new Date();
                }
                closeTimeDescription = DisplayHelper.formatTradingDayCloseTime(closeTime);
                return day.getLabel() + " " + closeTimeDescription;
            }
            return DisplayHelper.getDisplayableDate(searcher.getTradingDayDateRangeAdapter());
        }

        public static String getDisplayableDate(IRangedSearchFilter<Date> dateFilter) {
            if (dateFilter.hasSearchValue()) {
                Date end;
                Date start = dateFilter.getStart();
                if (start.after(end = dateFilter.getEnd())) {
                    Date temp = start;
                    start = end;
                    end = temp;
                }
                String desc = DateTimeUtils.formatDateForDisplay(start) + " to " + DateTimeUtils.formatDateForDisplay(end);
                return desc;
            }
            return "No date range selected";
        }

        public static String formatTradingDay(TradingDay tradingDay) {
            Date closeTime = tradingDay.getCloseDateTime();
            if (closeTime == null) {
                closeTime = new Date();
            }
            return tradingDay.getFullLabel() + " " + DisplayHelper.formatTradingDayCloseTime(closeTime);
        }

        public static String formatTradingDayCloseTime(Date closeTime) {
            return "(Close Time: " + DateTimeUtils.getDateTimeFormat().format(closeTime) + ")";
        }
    }

    public static class Factory {
        public static IRangedQuerySearchFilter<Date> createDateRangeFilter(PropertiedObject.Property ... joinPath) {
            return new RangeJoinSearchFilter<Date>(joinPath, new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP));
        }

        public static ISingleValueSearchFilter<TradingDay> createTradingDayFilter(PropertiedObject.Property ... propertyPath) {
            ObjectSearchFilter<TradingDay> filter = new ObjectSearchFilter<TradingDay>(propertyPath[0]);
            if (propertyPath.length == 1) {
                return filter;
            }
            return new ObjectJoinSearchFilter<TradingDay>(propertyPath, filter);
        }
    }
}

