/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports;

import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.search.offset.DateOffsetFunctions;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public abstract class YearOnYearPeriod
extends PeriodReportAdapter {
    public static final YearOnYearPeriod DAY = new YearOnYearPeriod(){

        @Override
        public List<Date> getDateList() {
            Date firstTradingDay = DateTimeUtils.getStartOfDay(TradingDay.ReportDates.getFirstTradingDay().getDate());
            Date lastTradingDay = DateTimeUtils.getStartOfDay(TradingDay.ReportDates.getLastTradingDay().getDate());
            Calendar lastTradingCal = Calendar.getInstance();
            lastTradingCal.setTime(lastTradingDay);
            ArrayList<Date> dates = new ArrayList<Date>();
            Calendar day = Calendar.getInstance();
            day.setTime(firstTradingDay);
            while (day.before(lastTradingCal) || day.equals(lastTradingCal)) {
                dates.add(day.getTime());
                day.add(6, 1);
            }
            Collections.reverse(dates);
            return dates;
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_DAY;
        }

        @Override
        public String getLabel() {
            return "Daily";
        }

        @Override
        public String getUnitOfTime() {
            return "Day";
        }

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("EEEE, dd MMM yyyy");
        }

        @Override
        public SQLPeriodFunction getSQLFunction() {
            return SQLPeriodFunction.DAY;
        }

        @Override
        public String getTitle() {
            return "Daily";
        }
    };
    public static final YearOnYearPeriod WEEK = new YearOnYearPeriod(){

        @Override
        public List<Date> getDateList() {
            return TradingDay.ReportDates.getLastDayOfWeekDates();
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_WEEK_ENDING;
        }

        @Override
        public String getLabel() {
            return "Week Ending";
        }

        @Override
        public String getUnitOfTime() {
            return "Week Ending";
        }

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("EEEE, dd MMM yyyy");
        }

        @Override
        public String formatDateForDisplay(Date date) {
            return "Week Ending " + super.formatDateForDisplay(this.getDateOffset().calcStart(date));
        }

        @Override
        public SQLPeriodFunction getSQLFunction() {
            return SQLPeriodFunction.WEEK;
        }

        @Override
        public String getTitle() {
            return "Weekly";
        }
    };
    public static final YearOnYearPeriod MONTH = new YearOnYearPeriod(){

        @Override
        public List<Date> getDateList() {
            List<Date> monthDates = TradingDay.ReportDates.getStartMonthDates();
            return monthDates.subList(0, Math.min(monthDates.size(), 12));
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_MONTH;
        }

        @Override
        public String getLabel() {
            return "Monthly";
        }

        @Override
        public String getUnitOfTime() {
            return "Month";
        }

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("MMMM yyyy");
        }

        @Override
        public SQLPeriodFunction getSQLFunction() {
            return SQLPeriodFunction.MONTH;
        }

        @Override
        public String getTitle() {
            return "Monthly";
        }
    };
    public static final YearOnYearPeriod QUARTER = new YearOnYearPeriod(){

        @Override
        public List<Date> getDateList() {
            List<Date> quarterDates = TradingDay.ReportDates.getStartQuarterDates();
            return quarterDates.subList(0, Math.min(4, quarterDates.size()));
        }

        @Override
        public DateOffsetFunction getDateOffset() {
            return DateOffsetFunctions.END_QUARTER;
        }

        @Override
        public String getLabel() {
            return "Quarterly";
        }

        @Override
        public String getUnitOfTime() {
            return "Quarter";
        }

        @Override
        public DateFormat getFormatter() {
            return new SimpleDateFormat("MMMM yyyy");
        }

        @Override
        public SQLPeriodFunction getSQLFunction() {
            return SQLPeriodFunction.QUARTER;
        }

        @Override
        public String formatDateForDisplay(Date date) {
            return "Qtr Beginning " + this.getFormatter().format(this.getDateOffset().calcStart(date));
        }

        @Override
        public String getTitle() {
            return "Quarterly";
        }
    };

    public abstract SQLPeriodFunction getSQLFunction();

    public static enum PeriodType {
        DAILY("Daily", DAY),
        WEEKLY("Weekly", WEEK),
        MONTHLY("Monthly", MONTH),
        QUARTERLY("Quarterly", QUARTER);

        private String desc;
        private YearOnYearPeriod period;

        private PeriodType(String desc, YearOnYearPeriod period) {
            this.desc = desc;
            this.period = period;
        }

        public YearOnYearPeriod getYearOnYearPeriod() {
            return this.period;
        }

        public SQLPeriodFunction getSQLPeriodFunction() {
            return this.period.getSQLFunction();
        }

        public String toString() {
            return this.desc;
        }

        public static PeriodType getPeriodType(SQLPeriodFunction function) {
            for (PeriodType periodType : PeriodType.values()) {
                if (periodType.getYearOnYearPeriod().getSQLFunction() != function) continue;
                return periodType;
            }
            return null;
        }

        public static boolean isValidFunction(SQLPeriodFunction function) {
            for (PeriodType periodType : PeriodType.values()) {
                if (periodType.getYearOnYearPeriod().getSQLFunction() != function) continue;
                return true;
            }
            return false;
        }
    }
}

