/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.adjustments;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.reports.AdjustmentsReportQueries;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import org.apache.commons.lang.NotImplementedException;

public class AdjustmentsReportSearcher
extends PropertySearcher<AdjustmentsReport>
implements TradingDayFilteredReportSearcher<AdjustmentsReport> {
    private final ISingleValueSearchFilter<TradingDay> tradingDaySearchFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearchFilter;
    private final MultiOptionSearchFilter<User> userSearchFilter;
    private final ObjectJoinSearchFilter<PriceAdjustmentDirection> directionSearchFilter;
    private final ObjectSearchFilter<PriceAdjustmentLevel> levelSearchFilter;
    private final MultiOptionSearchFilter adjustmentTypeSearchFilter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final TimeSearchFilter timeFilter;
    private SingleValueSearchFilter<PeriodReportAdapter.PeriodAndDateRange> periodFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;
    private BooleanSearchFilter perUnitFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private PeriodReportAdapter periodAdapter;

    public AdjustmentsReportSearcher() {
        this((PriceAdjustmentDirection)null);
    }

    public AdjustmentsReportSearcher(PriceAdjustmentDirection dir) {
        super(AdjustmentsReport.class);
        this.tradingDaySearchFilter = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(SalesPriceAdjustment.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearchFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(SalesPriceAdjustment.Properties.TRADING_DAY);
        this.userSearchFilter = new MultiOptionSearchFilter<User>(SalesPriceAdjustmentUsage.Properties.USER);
        this.directionSearchFilter = new ObjectJoinSearchFilter<PriceAdjustmentDirection>(new PropertiedObject.Property[]{SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT}, new ObjectSearchFilter<PriceAdjustmentDirection>(SalesPriceAdjustment.Properties.DIRECTION));
        this.levelSearchFilter = new ObjectSearchFilter<PriceAdjustmentLevel>(SalesPriceAdjustment.Properties.LEVEL);
        this.adjustmentTypeSearchFilter = new MultiOptionSearchFilter<PriceAdjustmentType>(SalesPriceAdjustment.Properties.TYPE);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesPriceAdjustment.Properties.SALES_LOCATION);
        this.timeFilter = new TimeSearchFilter(SalesPriceAdjustment.Properties.TIMESTAMP);
        this.periodFilter = new ObjectSearchFilter<PeriodReportAdapter.PeriodAndDateRange>(null);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.tradingDayDateRangeSearchFilter, null);
        this.perUnitFilter = new BooleanSearchFilter(new PropertiedObject.Property(AdjustmentsReport.class, "notAProp"));
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeSearchFilter);
        this.addSearchFilter(this.tradingDaySearchFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.userSearchFilter);
        this.addSearchFilter(this.directionSearchFilter);
        this.addSearchFilter(this.levelSearchFilter);
        this.addSearchFilter(this.adjustmentTypeSearchFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.directionSearchFilter.setSearchValue(dir);
        this.perUnitFilter.setNot(true);
    }

    public void initWebFilter() {
        if (this.periodFilter.hasSearchValue()) {
            this.periodAdapter = this.periodFilter.getSearchValue().getPeriod();
        }
    }

    @Override
    public ObjectQuery getObjectQuery() {
        if (this.isPerUnit()) {
            ObjectQuery allQuery = AdjustmentsReportQueries.getPerUnitQuery();
            this.addSearchFilterRestrictions(allQuery);
            return allQuery;
        }
        ObjectQuery accountQuery = this.getAccountQuery();
        ObjectQuery itemQuery = this.getItemQuery();
        this.addSearchFilterRestrictions(accountQuery);
        this.addSearchFilterRestrictions(itemQuery);
        return itemQuery.union(accountQuery);
    }

    protected ObjectQuery getAccountQuery() {
        return AdjustmentsReportQueries.getAccountQuery();
    }

    protected ObjectQuery getItemQuery() {
        return AdjustmentsReportQueries.getItemQuery();
    }

    public void setDateRange(Date firstDate, Date secondDate) {
        if (firstDate.compareTo(secondDate) > 0) {
            this.tradingDayDateRangeSearchFilter.setStart(secondDate);
            this.tradingDayDateRangeSearchFilter.setEnd(firstDate);
        } else {
            this.tradingDayDateRangeSearchFilter.setStart(firstDate);
            this.tradingDayDateRangeSearchFilter.setEnd(secondDate);
        }
    }

    public void setStartDate(Date value) {
        this.tradingDayDateRangeSearchFilter.setStart(value);
    }

    public void setEndDate(Date value) {
        this.tradingDayDateRangeSearchFilter.setEnd(value);
    }

    public void setUsers(Collection listOfUsers) {
        this.userSearchFilter.setSearchOptions(listOfUsers);
    }

    @FilterConfig(name="Time", dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, dataType=Date.class, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    public void setDirection(PriceAdjustmentDirection direction) {
        this.directionSearchFilter.setSearchValue(direction);
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=4)
    public MultiOptionSearchFilter<User> getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @FilterConfig(name="Direction", dataType=PriceAdjustmentDirection.class, plural=FilterConfig.Plural.Single, nullAllowed=true, ignore=true, priority=false, sequence=6)
    public ISingleValueSearchFilter<PriceAdjustmentDirection> getDirectionSearchFilter() {
        return this.directionSearchFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public String getDisplayableDate() {
        if (this.periodAdapter != null) {
            if (this.getTradingDayDateRangeFilter().hasSearchValue()) {
                return this.periodAdapter.formatTradingDayRangeForDisplay((Date)this.getTradingDayDateRangeFilter().getStart(), (Date)this.getTradingDayDateRangeFilter().getEnd(), (Date)this.getTradingDayDateRangeAdapter().getEnd());
            }
            if (this.getTradingDayFilter().hasSearchValue()) {
                return this.periodAdapter.formatDateForDisplay(this.getTradingDayFilter().getSearchValue().getDate());
            }
        }
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @Override
    @FilterConfig(name="Date Range", dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, dateType=SQLDateType.DATE, priority=true, sequence=1, filterLink="Period")
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateRangeSearchFilter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearchFilter;
    }

    @FilterConfig(name="Level", dataType=PriceAdjustmentLevel.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=5)
    public ObjectSearchFilter<PriceAdjustmentLevel> getLevelFilter() {
        return this.levelSearchFilter;
    }

    @FilterConfig(name="Type", dataType=PriceAdjustmentType.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=3)
    public MultiOptionSearchFilter getTypeSearchFilter() {
        return this.adjustmentTypeSearchFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(name="Per Unit", dataType=PriceAdjustmentLevel.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=9)
    public BooleanSearchFilter getPerUnitFilter() {
        return this.perUnitFilter;
    }

    public List<AdjustmentsReport> getObjectList(ObjectQuery query) {
        return PersistenceManager.getObjectList(AdjustmentsReport.class, query.toString());
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        throw new NotImplementedException("Base query not implemented for AdjustmentReportSearcher due to union query");
    }

    public void setPeriodAdapter(PeriodReportAdapter periodAdapter) {
        this.periodAdapter = periodAdapter;
    }

    @FilterConfig(name="Period", dataType=PeriodReportAdapter.PeriodAndDateRange.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=2, filterLink="Date Range", defaultValue="DateRange")
    public ISingleValueSearchFilter<PeriodReportAdapter.PeriodAndDateRange> getPeriodFilter() {
        return this.periodFilter;
    }

    public boolean isPerUnit() {
        return !this.perUnitFilter.isNot();
    }
}

