/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.categorytotal;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.categorytotal.CategoryTotalReport;
import ordermate.database.reports.categorytotal.CategoryTotalReportCreator;
import ordermate.database.searchers.reports.categorytotal.CategoryTotalReportSearcher;

public class CategoryTotalReportCompiler {
    private boolean canSave;

    public CategoryTotalReportCompiler(boolean saveOnCreate) {
        this.canSave = saveOnCreate;
    }

    public List<CategoryTotalReport> compile(Date from, Date to) {
        ArrayList<CategoryTotalReport> reports = new ArrayList<CategoryTotalReport>();
        CategoryTotalReportSearcher searcher = new CategoryTotalReportSearcher();
        searcher.getKeyCategorySearchFilter().clearSearch();
        OptimisedDateRangeSearchFilter dateFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        TradingDayDateRangeFilterAdapter dateAdapter = new TradingDayDateRangeFilterAdapter(dateFilter);
        dateFilter.setStart(from);
        dateFilter.setEnd(to);
        List<TradingDay> days = PersistenceManager.getObjectList(TradingDay.class, dateAdapter.addQueryRestriction(Query.select(TradingDay.class)).toString(), null);
        searcher.getDateRangeFilter().clearSearch();
        List<InventoryCategory> categories = this.getCategories();
        for (TradingDay day : days) {
            List<CategoryTotalReport> newReports;
            if (day.getCloseDate() == null) {
                newReports = this.buildNew(day);
            } else {
                searcher.getTradingDaySearch().setSearchValue(day);
                newReports = searcher.search();
                if (newReports.size() != categories.size()) {
                    for (CategoryTotalReport nextReport : newReports) {
                        nextReport.delete();
                    }
                    newReports = this.buildNew(day);
                    if (this.canSave) {
                        for (CategoryTotalReport nextReport : newReports) {
                            nextReport.save();
                        }
                    }
                }
            }
            for (CategoryTotalReport nextReport : newReports) {
                reports.add(nextReport);
            }
        }
        return reports;
    }

    protected List<InventoryCategory> getCategories() {
        return InventoryCategory.getAllCategories();
    }

    protected List<CategoryTotalReport> buildNew(TradingDay day) {
        return new CategoryTotalReportCreator().getReportsForTradingDay(day);
    }
}

