/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.categorytotal;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.categorytotal.CategoryTotalReport;

public class CategoryTotalReportSearcher
extends PropertySearcher<CategoryTotalReport> {
    private final IRangedQuerySearchFilter<Date> dateRangeSearch;
    private final ISingleValueSearchFilter<TradingDay> tradingDaySearch;
    private final ISingleValueSearchFilter<Boolean> keyCategoryFilter;

    public CategoryTotalReportSearcher() {
        super(CategoryTotalReport.class);
        this.dateRangeSearch = new OptimisedDateRangeSearchFilter(CategoryTotalReport.Properties.REPORT_DATE, SQLDateType.TIMESTAMP);
        this.tradingDaySearch = new ObjectSearchFilter<TradingDay>(CategoryTotalReport.Properties.TRADING_DAY);
        this.keyCategoryFilter = new ObjectJoinSearchFilter<Boolean>(new PropertiedObject.Property[]{CategoryTotalReport.Properties.CATEGORY}, new ObjectSearchFilter(InventoryCategory.Properties.KEY_CATEGORY));
        this.addSearchFilter(this.dateRangeSearch);
        this.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.keyCategoryFilter);
    }

    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeSearch;
    }

    public ISingleValueSearchFilter<TradingDay> getTradingDaySearch() {
        return this.tradingDaySearch;
    }

    public ISingleValueSearchFilter<Boolean> getKeyCategorySearchFilter() {
        return this.keyCategoryFilter;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(CategoryTotalReport.class);
    }
}

