/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ordermate.OrderMate;
import ordermate.database.reports.dailysales.DailySalesReport;
import ordermate.database.searchers.reports.dailysales.DailySalesReportSearcher;

public class DailySalesReportCompiler {
    private DailySalesReportSearcher searcher;
    private List<DailySalesReport> cachedResults;
    private final Semaphore cacheAccess = new Semaphore(1);
    private AtomicBoolean hasCachedResults;

    public DailySalesReportCompiler(DailySalesReportSearcher searcher) {
        this.searcher = searcher;
        this.cachedResults = new ArrayList<DailySalesReport>();
        this.hasCachedResults = new AtomicBoolean(false);
    }

    public List<DailySalesReport> compileResults() {
        Map<Date, DailySalesReport> summaryResults = this.createEmptyDatasetMap();
        this.generateCompiledResults(summaryResults);
        try {
            this.cacheAccess.acquire();
        }
        catch (InterruptedException e) {
            OrderMate.LOG.warn("Could now get permission for cache access for cachedResults", (Throwable)e);
        }
        this.cachedResults.clear();
        if (Boolean.TRUE.equals(this.searcher.getHideEmptySalesFilter().getSearchValue())) {
            this.cachedResults.addAll(this.getFilteredResults(summaryResults.values()));
        } else {
            this.cachedResults.addAll(summaryResults.values());
        }
        Collections.sort(this.cachedResults);
        this.cacheAccess.release();
        this.hasCachedResults.getAndSet(true);
        return this.cachedResults;
    }

    private void generateCompiledResults(Map<Date, DailySalesReport> results) {
        DailySalesReport summaryReport;
        Date keyDate;
        for (DailySalesReport salesbyPeriodReport : this.searcher.search()) {
            keyDate = this.getMapDateKey(salesbyPeriodReport);
            if (!results.containsKey(keyDate)) continue;
            summaryReport = results.get(keyDate);
            summaryReport.setSales(summaryReport.getSales().add(salesbyPeriodReport.getSales().multiply(salesbyPeriodReport.getTradeVolume())));
            summaryReport.setTradeVolume(summaryReport.getTradeVolume().add(salesbyPeriodReport.getTradeVolume()));
        }
        for (DailySalesReport salesbyPeriodReport : this.searcher.getAccountInformationList()) {
            keyDate = this.getMapDateKey(salesbyPeriodReport);
            if (!results.containsKey(keyDate)) continue;
            summaryReport = results.get(keyDate);
            summaryReport.setPatrons(summaryReport.getPatrons() + salesbyPeriodReport.getPatrons());
        }
    }

    private Map<Date, DailySalesReport> createEmptyDatasetMap() {
        HashMap<Date, DailySalesReport> baseList = new HashMap<Date, DailySalesReport>();
        Calendar startTime = this.searcher.getStartDateTime();
        startTime.set(12, 0);
        startTime.set(13, 0);
        Calendar endDate = DateTimeUtils.getCalendar(startTime.getTime());
        endDate.add(12, 30);
        for (int i = 0; i < 48; ++i) {
            baseList.put(startTime.getTime(), new DailySalesReport(startTime.getTime(), endDate.getTime()));
            startTime.add(12, 30);
            endDate.add(12, 30);
        }
        return baseList;
    }

    private Date getMapDateKey(DailySalesReport salesByPeriodReport) {
        Calendar keyDate = DateTimeUtils.getCalendar(salesByPeriodReport.getCreationTime());
        keyDate.set(14, 0);
        keyDate.set(13, 0);
        if (keyDate.get(12) > 30) {
            keyDate.set(12, 30);
        } else {
            keyDate.set(12, 0);
        }
        return keyDate.getTime();
    }

    public List<DailySalesReport> getResults() {
        if (!this.hasCachedResults.get()) {
            this.compileResults();
        }
        try {
            this.cacheAccess.tryAcquire(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.warn("Could now get permission for cache access for cachedResults", (Throwable)e);
        }
        ArrayList<DailySalesReport> toReturn = new ArrayList<DailySalesReport>(this.cachedResults);
        this.cacheAccess.release();
        return toReturn;
    }

    public List<DailySalesReport> getFilteredResults(Collection<DailySalesReport> unfilteredResults) {
        ArrayList<DailySalesReport> filteredList = new ArrayList<DailySalesReport>();
        for (DailySalesReport dailyReport : unfilteredResults) {
            if (dailyReport.getSales().isZero() && dailyReport.getTradeVolume().equals(SalesQuantity.ZERO)) continue;
            filteredList.add(dailyReport);
        }
        return filteredList;
    }

    public List<String> getDailySalesFiguresColumnNamesList() {
        return new ArrayList<String>(this.getDailySalesFiguresColumns().keySet());
    }

    public Map<String, String> getDailySalesFiguresColumns() {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        columnMap.put("timePeriod", "Time");
        columnMap.put("sales", "Sales");
        columnMap.put("patrons", "Patrons");
        columnMap.put("tradeVolumeRaw", "Trade Volume");
        return columnMap;
    }

    public List<List<String>> getDailySalesFiguresReportData() {
        ArrayList<List<String>> reportData = new ArrayList<List<String>>();
        try {
            this.cacheAccess.tryAcquire(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.warn("Could now get permission for cache access for cachedResults", (Throwable)e);
        }
        int toLoopFor = this.cachedResults.size();
        for (int i = 0; i < toLoopFor; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(this.cachedResults.get(i).getTimePeriod());
            row.add(this.cachedResults.get(i).getSales().toString());
            row.add(Integer.toString(this.cachedResults.get(i).getPatrons()));
            row.add(this.cachedResults.get(i).getTradeVolume().toString());
            reportData.add(row);
        }
        this.cacheAccess.release();
        return reportData;
    }

    public DailySalesReportSearcher getSearcher() {
        return this.searcher;
    }

    public void setFilterPeriodsWithNoSalesData(boolean filterPeriods) {
        this.searcher.getHideEmptySalesFilter().setSearchValue(filterPeriods);
    }
}

