/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayByDateFilterAdapter;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysales.DailySalesReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class DailySalesReportSearcher
extends PropertySearcher<DailySalesReport> {
    private final ISingleValueSearchFilter<TradingDay> tradingDayFilter;
    private final TradingDayByDateFilterAdapter tradingDayDateFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final BooleanSearchFilter hideZeroSales;

    public DailySalesReportSearcher() {
        super(DailySalesReport.class);
        this.tradingDayFilter = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateFilter = new TradingDayByDateFilterAdapter(this.tradingDayFilter);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.hideZeroSales = new BooleanSearchFilter(null);
        this.addSearchFilter(this.tradingDayDateFilter);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SalesItemQuantity.Properties.ID).sum(SalesComponent.Properties.SAVED_UNIT_PRICE, "Price").select(SalesItemQuantity.Properties.CREATION_TIME, "time_period").select(SalesItemQuantity.Properties.CREATION_TIME, "start_time").select(SalesItemQuantity.Properties.CREATION_TIME, "end_time").sum(SalesItemQuantity.Properties.QUANTITY, "Quantity").select(0.0, "num_patrons").select(Account.Properties.ID, "account_id").wherePropertyBetween(SalesItemQuantity.Properties.CREATION_TIME, this.getStartDateTime().getTime(), this.getEndDateTime().getTime(), SQLDateType.TIMESTAMP).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesLineItem.Properties.ACCOUNT, Account.Properties.ID).groupBy(SalesItemQuantity.Properties.ID).orderBy(SalesLineItem.Properties.ID);
        return query;
    }

    protected List<DailySalesReport> getAccountInformationList() {
        ObjectQuery accountDetailsQuery = Query.select(SalesLineItem.Properties.ID).select(Account.Properties.CREATION_DATE_TIME, "time_period").select(Account.Properties.CREATION_DATE_TIME, "start_time").select(Account.Properties.CREATION_DATE_TIME, "end_time").select(0.0, "Price").select(0.0, "Quantity").select(Account.Properties.NUM_PATRONS, "num_patrons").select(Account.Properties.ID, "account_id").wherePropertyBetween(Account.Properties.CREATION_DATE_TIME, this.getStartDateTime().getTime(), this.getEndDateTime().getTime(), SQLDateType.TIMESTAMP).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesLineItem.Properties.ACCOUNT, Account.Properties.ID).groupBy(Account.Properties.ID).orderBy(Account.Properties.ID);
        return PersistenceManager.getObjectList(DailySalesReport.class, accountDetailsQuery.toString());
    }

    @Override
    public List<DailySalesReport> search() {
        this.tradingDayDateFilter.update();
        return super.search();
    }

    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @FilterConfig(name="Trading Day", defaultValue="DateRange", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public ISingleValueSearchFilter<Date> getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }

    @FilterConfig(name="Hide Zero Sales", dataType=Boolean.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public BooleanSearchFilter getHideEmptySalesFilter() {
        return this.hideZeroSales;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, nullAllowed=true, plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDay(this.getSpecifiedDay());
    }

    public Calendar getStartDateTime() {
        return DateTimeUtils.toCal(this.getSpecifiedDay().getOpenDateTime());
    }

    public Calendar getEndDateTime() {
        Date endTime = this.getSpecifiedDay().getCloseDateTime();
        if (endTime == null) {
            endTime = new Date();
        }
        return DateTimeUtils.toCal(endTime);
    }

    private TradingDay getSpecifiedDay() {
        if (!this.tradingDayFilter.hasSearchValue()) {
            this.tradingDayDateFilter.update();
            if (!this.tradingDayFilter.hasSearchValue()) {
                return TradingDay.getCurrentTradingDay();
            }
        }
        return this.tradingDayFilter.getSearchValue();
    }
}

