/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReport;
import ordermate.database.sales.Account;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyDebtorSummaryReportSearcher
extends PropertySearcher<DailyDebtorSummaryReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;
    private final DateRangeSearchFilter salesDateRangeFilter;
    private final DateRangeSearchFilter paidDateRangeFilter;

    public DailyDebtorSummaryReportSearcher() {
        super(DailyDebtorSummaryReport.class);
        this.salesDateRangeFilter = new OptimisedDateRangeSearchFilter(DebtorSale.Properties.SALE_DATE, SQLDateType.TIMESTAMP);
        this.paidDateRangeFilter = new OptimisedDateRangeSearchFilter(FinanceTransaction.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        if (this.params != null) {
            this.removeSearchFilter(this.paidDateRangeFilter);
        }
        this.params = theParams;
        this.addSearchFilter(this.paidDateRangeFilter);
    }

    @Override
    public ObjectQuery getObjectQuery() {
        Date start = this.params.getStart();
        Date end = this.params.getEnd();
        this.salesDateRangeFilter.setStart(start);
        this.salesDateRangeFilter.setEnd(end);
        this.paidDateRangeFilter.setStart(start);
        this.paidDateRangeFilter.setEnd(end);
        return super.getObjectQuery();
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery paymentsQuery = Query.select(DebtorPayment.Properties.ID).select(FinanceTransaction.Properties.CREATION_TIME).selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd())).select(0.0, "sales").select(0.0, "discounts").select(0.0, "surcharges").linkUsing(TradingDay.Properties.ID, FinanceTransaction.Properties.TRADING_DAY).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION, FinanceTransaction.Properties.ID);
        if (this.params.getSalesLocationsFilter().getSelectedOptions() != null && !this.params.getSalesLocationsFilter().getSelectedOptions().isEmpty()) {
            paymentsQuery = paymentsQuery.linkUsing(FinanceTransaction.Properties.SALES_LOCATION, SalesLocation.Properties.ID).wherePropertyIn(SalesLocation.Properties.ID, this.params.getSalesLocationsFilter().getSelectedOptions());
        }
        paymentsQuery.sum(DebtorPayment.Properties.AMOUNT, "payments").groupBy("day_of_week");
        return paymentsQuery;
    }

    public ObjectQuery getSalesQuery() {
        ObjectQuery salesQuery = Query.select(DebtorSale.Properties.ID).select(DebtorSale.Properties.SALE_DATE).selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplit(DebtorSale.Properties.SALE_DATE, this.params.getStart(), this.params.getEnd())).sum(DebtorSale.Properties.TOTAL, "sales").select(0.0, "payments").select(0.0, "discounts").select(0.0, "surcharges").groupBy("day_of_week");
        salesQuery = this.salesDateRangeFilter.addQueryRestriction(salesQuery);
        if (this.params.getSalesLocationsFilter().getSelectedOptions() != null && this.params.getSalesLocationsFilter().getSelectedOptions().size() != 0) {
            salesQuery = salesQuery.linkUsing(DebtorSale.Properties.SALE_ACCOUNT, Account.Properties.ID).linkUsing(Account.Properties.SALES_LOCATION, SalesLocation.Properties.ID).wherePropertyIn(SalesLocation.Properties.ID, this.params.getSalesLocationsFilter().getSelectedOptions());
        }
        return salesQuery;
    }

    public ObjectQuery getAdjustmentsQuery() {
        FinanceUnit unit = FinanceUnit.getUnitForName("Debtor Adjustment");
        ObjectQuery adjustmentsQuery = Query.select(DebtorPayment.Properties.ID).select(FinanceTransaction.Properties.CREATION_TIME).selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd())).select(0.0, "sales").selectFunc(" SUM(IF(" + DebtorPayment.Properties.AMOUNT + " > 0, " + DebtorPayment.Properties.AMOUNT + ", 0)) as 'discounts'").selectFunc(" SUM(IF(" + DebtorPayment.Properties.AMOUNT + " < 0, " + DebtorPayment.Properties.AMOUNT + ", 0)) as 'surcharges'").select(0.0, "payments").linkUsing(TradingDay.Properties.ID, FinanceTransaction.Properties.TRADING_DAY).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION, FinanceTransaction.Properties.ID);
        if (this.params.getSalesLocationsFilter().getSelectedOptions() != null && this.params.getSalesLocationsFilter().getSelectedOptions().size() != 0) {
            adjustmentsQuery = adjustmentsQuery.linkUsing(FinanceTransaction.Properties.SALES_LOCATION, SalesLocation.Properties.ID).wherePropertyIn(SalesLocation.Properties.ID, this.params.getSalesLocationsFilter().getSelectedOptions());
        }
        adjustmentsQuery.equals(FinanceTransaction.Properties.SUB_TYPE, unit).groupBy("day_of_week");
        return adjustmentsQuery;
    }
}

