/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.PropertySearcher;
import java.util.Date;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketDataSummary;
import ordermate.database.reports.dailysummary.DailyKTSReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyKTSReportSearcher
extends PropertySearcher<DailyKTSReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;
    private final TimeSearchFilter dayPartFilter;

    public DailyKTSReportSearcher() {
        super(DailyKTSReport.class);
        this.dayPartFilter = new TimeSearchFilter(KTSDocketData.Properties.CREATED);
        this.addSearchFilter(this.dayPartFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        Date from = this.params.getStart();
        Date to = this.params.getEnd();
        ObjectQuery oQuery = KTSDocketDataSummary.getSummaryQuery(from, to, null);
        oQuery.selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplit(KTSDocketData.Properties.CREATED, from, to)).groupBy("day_of_week");
        return oQuery;
    }

    public TimeSearchFilter getDayPartFilter() {
        return this.dayPartFilter;
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        this.params = theParams;
    }
}

