/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyNumPatronsByAccountSearcher
extends PropertySearcher<DailyPatronsReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;
    private final ObjectSearchFilter<AccountType> accountTypeFilter;
    private final DateRangeSearchFilter dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final TimeSearchFilter dayPartFilter;
    private MultiOptionSearchFilter<SalesLocation> dirtyLocationFilter;
    private ObjectQuery basequery;

    public DailyNumPatronsByAccountSearcher() {
        super(DailyPatronsReport.class);
        this.accountTypeFilter = new ObjectSearchFilter<AccountType>(Account.Properties.ACCOUNT_TYPE);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.dayPartFilter = new TimeSearchFilter(Account.Properties.CREATION_DATE_TIME);
        this.dirtyLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.basequery = Query.select(Account.Properties.ID).sum(Account.Properties.NUM_PATRONS, "num_patrons").groupBy("day_of_week");
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.dayPartFilter);
        this.addSearchFilter(this.accountTypeFilter);
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        this.params = theParams;
        if (theParams.getSalesLocationsFilter() != null && !theParams.getSalesLocationsFilter().getSelectedOptions().isEmpty()) {
            this.dirtyLocationFilter.setSearchValue((Object)theParams.getSalesLocationsFilter().getSelectedOptions().get(0));
        }
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery toReturn = this.basequery.copy();
        toReturn.selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd()));
        toReturn.linkUsing(DailySummaryReportSearcher.TRADING_DAY_FK_LINK, TradingDay.Properties.ID);
        return toReturn;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery result = super.getObjectQuery();
        if (this.dirtyLocationFilter.hasSearchValue()) {
            result.joinFunction("JOIN (" + this.getNestedSalesItemQuery() + ") AS SI ON sales_account.id = SI.fk_sales_account ", SalesLineItem.class).whereIn("SI.FK_config_sales_location", this.dirtyLocationFilter.getSelectedOptions());
        }
        result.lastFrom("sales_account");
        return result;
    }

    private String getNestedSalesItemQuery() {
        ObjectQuery nestedSalesItemQuery = Query.selectFunc("MIN(sales_item.id) as ID, sales_item.fk_sales_account, sales_item.fk_config_terminal, sales_item_quantity.fk_config_sales_location FROM sales_item ").joinFunction("JOIN sales_account ON sales_item.fk_sales_account = sales_account.id ").joinFunction("JOIN sales_item_quantity ON sales_item.id = sales_item_quantity.fk_sales_item ").joinFunction("JOIN finance_trading_day ON sales_account.fk_finance_trading_day = finance_trading_day.id ").groupBy("sales_item.fk_sales_account");
        this.tradingDayDateRangeAdapter.addQueryRestriction(nestedSalesItemQuery);
        return nestedSalesItemQuery.toString().replace("FROM finance_trading_day", "");
    }

    public ObjectSearchFilter<AccountType> getAccountTypeFilter() {
        return this.accountTypeFilter;
    }

    @Override
    public List<DailyPatronsReport> search() {
        this.dateRangeFilter.setStart(this.params.getStart());
        this.dateRangeFilter.setEnd(this.params.getEnd());
        return super.search();
    }

    public void setLocation(SalesLocation location) {
        this.dirtyLocationFilter.setSearchValue((Object)location);
    }

    public void setDayPart(DayPart part) {
        if (part == null) {
            this.dayPartFilter.setStart((Calendar)null);
            this.dayPartFilter.setEnd((Calendar)null);
        } else {
            this.dayPartFilter.setStart(DateTimeUtils.toCal(part.getStartTime()));
            this.dayPartFilter.setEnd(DateTimeUtils.toCal(part.getEndTime()));
        }
    }
}

