/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.searchers.reports.TotalsReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyProductivitySummaryReportSearcher
extends TotalsReportSearcher<DailyProductivitySummaryReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;

    public DailyProductivitySummaryReportSearcher() {
        super(DailyProductivitySummaryReport.class);
    }

    @Override
    public ObjectQuery getObjectQuery() {
        IRangedQuerySearchFilter<Date> dateFilter = ((TradingDayDateRangeFilterAdapter)this.getTradingDayDateRangeAdapter()).getUnderlyingFilter();
        dateFilter.setStart(this.params.getStart());
        dateFilter.setEnd(this.params.getEnd());
        ObjectQuery query = super.getObjectQuery();
        return query;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        DeterminePatrons determinePatrons = SystemProperty.getInstance().getDeterminePatrons();
        this.getSalesDateTimeRangeFilter().setProperty(TradingDay.Properties.DATE);
        ObjectQuery query = super.getBaseQuery();
        query.selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd()));
        if (DeterminePatrons.Item.equals((Object)determinePatrons)) {
            query.selectFunc(" sum(" + InventoryItemUnit.Properties.NUM_PATRONS + " * sales_item_quantity.quantity) as 'num_patrons'").linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID);
        } else {
            query.select(0.0, "num_patrons");
        }
        query.groupBy("day_of_week");
        return query.copy();
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        this.params = theParams;
        if (theParams.getSalesLocationsFilter() != null) {
            this.getSalesLocationFilter().setSearchValue(theParams.getSalesLocationsFilter().getSearchValue());
        }
    }
}

