/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import java.util.List;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysummary.DailyReconciliationSummaryReport;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyReconciliationSummaryReportSearcher
extends PropertySearcher<DailyReconciliationSummaryReport>
implements DailySummaryReportSearcherI {
    DailySummaryReportParameters params;
    private DateRangeSearchFilter tradingDayRange;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;

    public DailyReconciliationSummaryReportSearcher() {
        super(DailyReconciliationSummaryReport.class);
        this.tradingDayRange = new OptimisedDateRangeSearchFilter(FinanceTransaction.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayRange);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        String financeTransactionTotal = "finance_transaction.amount_paid";
        if (SystemProperty.getInstance().isReconciliationSystemTotalIncludesTips()) {
            financeTransactionTotal = financeTransactionTotal + " + finance_transaction.tip";
        }
        ObjectQuery query = Query.select(CashDrawer.Properties.ID, "fk_config_cashdrawer").select(FinanceTransaction.Properties.ID, "id").selectFunc(" sum(if(finance_transaction.type = 'CASH', " + financeTransactionTotal + ", 0)) as 'expected_cash'").selectFunc(" sum(if(finance_transaction.type IN ('DEBIT', 'CREDIT'), " + financeTransactionTotal + ", 0)) as 'expected_card'").selectFunc(" sum(if(finance_transaction.type = 'WEB', " + financeTransactionTotal + ", 0)) as 'expected_web'").selectFunc(" sum(finance_transaction.cash_out) as 'expected_cash_out'").selectFunc(" 0 as 'actual_card'").selectFunc(" 0 as 'actual_cash'").selectFunc(" 0 as 'actual_web'").selectFunc(" 0 as 'actual_cash_out'").selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd())).not().equals(FinanceTransaction.Properties.SYSTEM_STATE, "DELETED").active(CashDrawer.class).isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).joinLeft(FinanceTransaction.class, FinanceTransaction.Properties.CASH_DRAWER).joinLeft(TradingDay.class, FinanceTransaction.Properties.TRADING_DAY).groupBy("day_of_week").groupBy(CashDrawer.Properties.ID).orderBy(CashDrawer.Properties.ID).orderBy(FinanceTransaction.Properties.ID);
        return query;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        this.tradingDayRange.setStart(this.params.getStart());
        this.tradingDayRange.setEnd(this.params.getEnd());
        return super.getObjectQuery();
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        this.params = theParams;
    }

    public List<ShiftReconciliation> getReconciliations() {
        ObjectQuery query = Query.select(ShiftReconciliation.class).linkUsing(ShiftReconciliation.Properties.SHIFT, Shift.Properties.ID).linkUsing(Shift.Properties.TRADING_DAY, TradingDay.Properties.ID);
        PropertiedObject.Property og = this.tradingDayDateRangeAdapter.getProperty();
        ((TradingDayDateRangeFilterAdapter)this.tradingDayDateRangeAdapter).getUnderlyingFilter().setProperty(TradingDay.Properties.DATE);
        query = this.tradingDayDateRangeAdapter.addQueryRestriction(query);
        ((TradingDayDateRangeFilterAdapter)this.tradingDayDateRangeAdapter).getUnderlyingFilter().setProperty(og);
        return PersistenceManager.getObjectList(ShiftReconciliation.class, query.toString());
    }

    public List<DailyReconciliationSummaryReport> getBreakoutReports(FinanceUnit unit) {
        ObjectQuery query = Query.select(CashDrawer.Properties.ID, "fk_config_cashdrawer").select(FinanceTransaction.Properties.ID, "id").selectFunc(" 0 as 'expected_cash'").selectFunc(" 0 as 'expected_cash_out'").selectFunc(" sum(if(finance_transaction.fk_finance_unit = " + unit.getID() + ", finance_transaction.amount_paid, 0)) as 'expected_card'").selectFunc(" 0 as 'expected_web'").selectFunc(" 0 as 'actual_card'").selectFunc(" 0 as 'actual_cash'").selectFunc(" 0 as 'actual_cash_out'").selectFunc(" 0 as 'actual_web'").selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd())).active(FinanceTransaction.class).active(CashDrawer.class).joinLeft(FinanceTransaction.class, FinanceTransaction.Properties.CASH_DRAWER).joinLeft(TradingDay.class, FinanceTransaction.Properties.TRADING_DAY).groupBy("day_of_week").groupBy(CashDrawer.Properties.ID).orderBy(CashDrawer.Properties.ID).orderBy(FinanceTransaction.Properties.ID);
        this.addSearchFilterRestrictions(query);
        return PersistenceManager.getObjectList(DailyReconciliationSummaryReport.class, query.toString());
    }
}

