/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.PropertySearcher;
import java.text.SimpleDateFormat;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReportProperties;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportType;

public class DailySalesSummaryReportSearcher
extends PropertySearcher<DailySalesSummaryReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;
    private boolean groupByLocation = true;

    public DailySalesSummaryReportSearcher() {
        super(DailySalesSummaryReport.class);
    }

    public void setGroupByLocation(boolean gbl) {
        this.groupByLocation = gbl;
    }

    public boolean isGroupByLocation() {
        return this.groupByLocation;
    }

    @Override
    public List<DailySalesSummaryReport> search() {
        DailySummaryReportType reportType = this.params.getReportType();
        List<DailySalesSummaryReport> reports = super.search();
        for (DailySalesSummaryReport report : reports) {
            reportType.formatLabel(report);
        }
        return reports;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = new ObjectQuery();
        query.min(SalesItemQuantity.Properties.ID, "id").min(SalesItemQuantity.Properties.CREATION_TIME, "day").selectFunc(new DailySummaryDayOfWeekSplitter(this.params).generateSQLForDayOfWeekSplitUsingTradingDayID(this.params.getStart(), this.params.getEnd())).linkUsing(TradingDay.Properties.ID, DailySummaryReportSearcher.TRADING_DAY_FK_LINK).selectFunc(" sum((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) as 'sales'").selectFunc(" sum(if( sales_item_quantity.item_state IN ('REFUNDED', 'REFUNDED_WASTED'), sales_component.unit_price * sales_item_quantity.quantity, 0)) as 'refunds'").selectFunc(" sum(sales_component.unit_tax * sales_item_quantity.quantity) as 'tax'").sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.PORTION, "volume").select(SalesItemQuantity.Properties.SALES_LOCATION);
        query.selectFunc(" sum(if(sales_account.account_type IN ('TABLE','ONLINE_TABLE'), (sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity, 0)) as 'patron_sales'");
        query.selectFunc(" sum(if(sales_account.account_type IN ('TABLE','ONLINE_TABLE'), ((sales_component.unit_price - sales_component.unit_tax + sales_component.item_discount_total + sales_component.account_discount_total + sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity), 0)) as 'patron_sales_before_adj'").selectFunc(" null as 'num_patrons'");
        query.selectFunc(" sum( (sales_component.item_discount_total + sales_component.account_discount_total) * sales_item_quantity.quantity) as 'discounts'");
        boolean adjustmentsEx = DailySalesSummaryReportProperties.isAdjustmentsEx();
        if (adjustmentsEx) {
            query.selectFunc(" sum( (sales_component.item_discount_total + sales_component.account_discount_total) * sales_item_quantity.quantity) /  ( 1 + sum(sales_component.unit_tax * sales_item_quantity.quantity) / sum((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity)) as 'discounts_ex'");
        } else {
            query.selectFunc(" 0 as 'discounts_ex'");
        }
        query.selectFunc(" sum( (sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity) as 'surcharges'");
        if (adjustmentsEx) {
            query.selectFunc(" sum( (sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity) /  ( 1 + sum(sales_component.unit_tax * sales_item_quantity.quantity) / sum((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity)) as 'surcharges_ex'");
        } else {
            query.selectFunc(" 0 as 'surcharges_ex'");
        }
        query.linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ID, SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(Account.Properties.ID, SalesItem.Properties.ACCOUNT).linkUsing(SalesItemQuantity.Properties.SALES_LOCATION, SalesLocation.Properties.ID);
        if (this.isGroupByLocation()) {
            query.groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
        }
        query.groupBy("day_of_week");
        this.params.getReportType().applyQueryParameters(query);
        if (this.params.getDayParts().size() > 1) {
            query.selectFunc(this.createDayPartQuery());
            query.groupBy("day_part");
        } else {
            query.select("None", "day_part");
        }
        return query;
    }

    private String createDayPartQuery() {
        int i;
        List<DayPart> dayParts = this.params.getDayParts();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        StringBuilder SB = new StringBuilder("");
        for (i = dayParts.size() - 1; i >= 0; --i) {
            DayPart part = dayParts.get(i);
            SB.append("if(TIME(sales_item_quantity.creation_time) >= TIME('");
            SB.append(format.format(part.getStartTime()));
            SB.append("'), '").append(part.getLabel()).append("', ");
        }
        SB.append("'").append(dayParts.get(dayParts.size() - 1).getLabel()).append("'");
        for (i = 0; i < dayParts.size(); ++i) {
            SB.append(")");
        }
        SB.append(" as 'day_part'");
        return SB.toString();
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters newParams) {
        if (this.params != null) {
            this.removeSearchFilter(this.params.getTradingDayDateRangeAdapter());
            this.removeSearchFilter(this.params.getSalesLocationsFilter());
        }
        this.params = newParams;
        this.addSearchFilter(this.params.getTradingDayDateRangeAdapter());
        this.addSearchFilter(this.params.getSalesLocationsFilter());
    }
}

