/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.TradingDayComparator;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;

public class DailySummaryDayOfWeekSplitter {
    protected DailySummaryReportParameters params;
    protected List<TradingDay> days;
    protected Map<Date, HashSet<TradingDay>> multiples;
    protected static final String NO_TRADING_DAY = "1 AS 'day_of_week'";

    public DailySummaryDayOfWeekSplitter(DailySummaryReportParameters reportParams) {
        this.params = reportParams;
        this.days = new ArrayList<TradingDay>();
        this.multiples = new HashMap<Date, HashSet<TradingDay>>();
    }

    public <T> String generateSQLForDayOfWeekSplit(PropertiedObject.Property<T> prop, Date startDate, Date endDate) {
        this.populateTradingDays(startDate, endDate);
        if (this.days.isEmpty()) {
            return NO_TRADING_DAY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(CASE ");
        for (int i = 0; i < this.days.size(); ++i) {
            sb.append("\n\t\t WHEN " + prop + " BETWEEN '").append(this.getDateForDayOfWeek(i + 1, false)).append("' AND '").append(this.getDateForDayOfWeek(i + 1, true)).append("' THEN ").append(i + 1);
        }
        sb.append("\n\t END) AS 'day_of_week'");
        return sb.toString();
    }

    @Deprecated
    public String generateSQLForDayOfWeekSplitUsingTradingDay(Date startDate, Date endDate) {
        this.populateTradingDays(startDate, endDate);
        if (this.days.isEmpty()) {
            return NO_TRADING_DAY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(CASE ");
        for (int i = 0; i < this.days.size(); ++i) {
            sb.append("\n\t\t WHEN TIMESTAMP(" + TradingDay.Properties.DATE + ", " + TradingDay.Properties.TIME + ") BETWEEN '").append(this.getDateForDayOfWeek(i + 1, false)).append("' AND '").append(this.getDateForDayOfWeek(i + 1, true)).append("' THEN ").append(i + 1);
        }
        sb.append("\n\t END) AS 'day_of_week'");
        return sb.toString();
    }

    public String generateSQLForDayOfWeekSplitUsingTradingDayID(Date startDate, Date endDate) {
        this.populateTradingDays(startDate, endDate);
        if (this.days.isEmpty()) {
            return NO_TRADING_DAY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(CASE ");
        for (int i = 0; i < this.days.size(); ++i) {
            if (i > 6) {
                sb.append("\n\t\t WHEN " + TradingDay.Properties.ID + this.getIDRangeForTradingDay(this.days.get(i)) + " THEN ").append(i % 7 + 1);
                continue;
            }
            sb.append("\n\t\t WHEN " + TradingDay.Properties.ID + this.getIDRangeForTradingDay(this.days.get(i)) + " THEN ").append(i + 1);
        }
        sb.append("\n\t END) AS 'day_of_week'");
        return sb.toString();
    }

    private String getIDRangeForTradingDay(TradingDay day) {
        if (day instanceof FillerTradingDay) {
            if (((FillerTradingDay)day).getIDs().isEmpty()) {
                return " = " + day.getID();
            }
            List<Long> ids = ((FillerTradingDay)day).getIDs();
            StringBuilder sb = new StringBuilder();
            for (Long id : ids) {
                sb.append(id);
                if (ids.indexOf(id) == ids.size() - 1) continue;
                sb.append(", ");
            }
            return " IN (" + sb.toString() + ")";
        }
        return " = " + day.getID();
    }

    private String getDateForDayOfWeek(int dayOfWeek, boolean closeDate) {
        TradingDay day = this.days.get(dayOfWeek - 1);
        if (closeDate) {
            if (day.getCloseDate() == null || day.getCloseTime() == null) {
                return DateTimeUtils.getSQLTimestampFormat().format(new Date());
            }
            return DateTimeUtils.getSQLTimestampFormat().format(DateTimeUtils.mergeDateAndTime(day.getCloseDate(), day.getCloseTime()));
        }
        return DateTimeUtils.getSQLTimestampFormat().format(DateTimeUtils.mergeDateAndTime(day.getDate(), day.getTime()));
    }

    private void populateTradingDays(Date startDate, Date endDate) {
        this.days.clear();
        this.days = PersistenceManager.getObjectList(TradingDay.class, new ObjectQuery().select(TradingDay.class).whereFunction("TIMESTAMP(finance_trading_day.day, finance_trading_day.time) >= ? AND TIMESTAMP(finance_trading_day.close_day, finance_trading_day.close_time) <= ? ").toString(), new Object[]{startDate, endDate});
        if (this.findMultipleDaysForDate()) {
            this.consolidateDays();
            Collections.sort(this.days, new TradingDayComparator());
        }
        if (this.days.size() < 7 && this.days.size() > 0) {
            TradingDay today;
            if ((Calendar.getInstance().getTime().before(endDate) || DateTimeUtils.dateIsToday(endDate)) && (today = TradingDay.getCurrentTradingDay()) != null && !this.days.contains(today)) {
                this.days.add(today);
            }
            if (this.days.size() < 7) {
                this.fillMissingTradingDays(startDate, endDate);
            }
        }
        Collections.sort(this.days, new TradingDayComparator());
    }

    private boolean findMultipleDaysForDate() {
        boolean result = false;
        ArrayList<TradingDay> copy = new ArrayList<TradingDay>(this.days);
        for (TradingDay day : this.days) {
            for (TradingDay dayCopy : copy) {
                if (!day.getDate().equals(dayCopy.getDate()) || day.getID().equals(dayCopy.getID())) continue;
                HashSet<TradingDay> tDaysForDate = this.multiples.get(day.getDate());
                if (tDaysForDate == null) {
                    HashSet<TradingDay> toAdd = new HashSet<TradingDay>();
                    toAdd.add(day);
                    this.multiples.put(day.getDate(), toAdd);
                } else {
                    tDaysForDate.add(day);
                }
                result = true;
            }
        }
        return result;
    }

    private void consolidateDays() {
        for (HashSet<TradingDay> tDays : this.multiples.values()) {
            ArrayList<TradingDay> sortedDays = new ArrayList<TradingDay>(tDays);
            Collections.sort(sortedDays, new TradingDayComparator());
            FillerTradingDay filler = new FillerTradingDay();
            TradingDay first = (TradingDay)sortedDays.get(0);
            filler.setDate(first.getDate());
            filler.setTime(first.getTime());
            filler.setCloseDate(first.getCloseDate());
            filler.setCloseTime(first.getCloseTime());
            for (TradingDay aDay : sortedDays) {
                if (aDay.getCloseDateTime().compareTo(filler.getCloseDateTime()) >= 0) {
                    filler.setCloseDate(aDay.getCloseDate());
                    filler.setCloseTime(aDay.getCloseTime());
                }
                filler.addID(aDay.getID());
                this.days.remove(aDay);
            }
            this.days.add(filler);
        }
    }

    private void fillMissingTradingDays(Date startDate, Date endDate) {
        if (this.days.isEmpty()) {
            OrderMate.LOG.warn("The date range from " + startDate + " to " + endDate + " has no trading days. This report will display no data.");
            return;
        }
        Collections.sort(this.days, new TradingDayComparator());
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.params.getDateFilter().getStart());
        if (((Date)this.params.getDateFilter().getStart()).after((Date)this.params.getDateFilter().getEnd())) {
            cal.setTime((Date)this.params.getDateFilter().getEnd());
        }
        while (!DateTimeUtils.clearTimePart(cal.getTime()).equals(this.days.get(0).getDate())) {
            FillerTradingDay fillerDay = new FillerTradingDay();
            fillerDay.setDate(DateTimeUtils.clearTimePart(cal.getTime()));
            fillerDay.setTime(cal.getTime());
            cal.add(6, 1);
            fillerDay.setCloseDate(DateTimeUtils.clearTimePart(cal.getTime()));
            fillerDay.setCloseTime(cal.getTime());
            this.days.add(fillerDay);
        }
        Collections.sort(this.days, new TradingDayComparator());
    }

    private class FillerTradingDay
    extends TradingDay {
        private List<Long> ids;

        private FillerTradingDay() {
        }

        public List<Long> getIDs() {
            if (this.ids == null) {
                this.ids = new ArrayList<Long>();
            }
            return this.ids;
        }

        public void addID(Long idToAdd) {
            if (this.ids == null) {
                this.ids = new ArrayList<Long>();
            }
            this.ids.add(idToAdd);
        }

        @Override
        public void save() {
        }

        @Override
        public Long getID() {
            return new Long(0L);
        }
    }
}

