/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportByCategory;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportType;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class DailySummaryReportParameters {
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final DateRangeSearchFilter dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final FixedRangeSearchFilter<Date> fixedRangeFilter;
    private DailySummaryReportType reportType;
    private final List<DayPart> dayParts;

    public DailySummaryReportParameters(List<DayPart> parts) {
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.dateRangeFilter, PeriodReportAdapter.WEEK_ENDING.getDateOffset());
        this.reportType = new DailySummaryReportByCategory();
        this.dayParts = new ArrayList<DayPart>(parts);
        this.fixedRangeFilter.setSearchValue(PeriodReportAdapter.WEEK_ENDING.getDateOffset().calcStart(new Date()));
    }

    @FilterConfig(name="Date", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    public DateRangeSearchFilter getDateFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    public Date getStart() {
        return (Date)this.tradingDayDateRangeAdapter.getStart();
    }

    public Date getEnd() {
        return (Date)this.tradingDayDateRangeAdapter.getEnd();
    }

    public void setReportType(DailySummaryReportType type) {
        if (type == null) {
            throw new IllegalArgumentException("The report type cannot be null!");
        }
        this.reportType = type;
    }

    public DailySummaryReportType getReportType() {
        return this.reportType;
    }

    public List<DayPart> getDayParts() {
        return Collections.unmodifiableList(this.dayParts);
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=2)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationsFilter() {
        return this.salesLocationFilter;
    }
}

