/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import ordermate.database.misc.DayPart;
import ordermate.database.sales.Account;
import ordermate.database.searchers.reports.dailysummary.DailyDebtorSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyKTSReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyNumPatronsByAccountSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyProductivitySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyReconciliationSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySalesSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportByAccountType;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportByCategory;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailyVoucherSummaryReportSearcher;

public class DailySummaryReportSearcher {
    public static final PropertiedObject.Property TRADING_DAY_FK_LINK = Account.Properties.TRADING_DAY;
    private DailySummaryReportParameters params;
    private final DailySalesSummaryReportSearcher salesSearcher = new DailySalesSummaryReportSearcher();
    private final DailyDebtorSummaryReportSearcher debtorSearcher = new DailyDebtorSummaryReportSearcher();
    private final DailyProductivitySummaryReportSearcher productivitySearcher = new DailyProductivitySummaryReportSearcher();
    private final DailyReconciliationSummaryReportSearcher reconciliationSearcher = new DailyReconciliationSummaryReportSearcher();
    private final DailyNumPatronsByAccountSearcher numPatronsSearcher = new DailyNumPatronsByAccountSearcher();
    private final DailyKTSReportSearcher ktsSearcher = new DailyKTSReportSearcher();
    private final DailyVoucherSummaryReportSearcher voucherSearcher = new DailyVoucherSummaryReportSearcher();

    public DailySummaryReportSearcher(List<DayPart> parts) {
        this.setParams(new DailySummaryReportParameters(parts));
    }

    public void setByCategory() {
        this.params.setReportType(new DailySummaryReportByCategory());
    }

    public void setByAccountType() {
        this.params.setReportType(new DailySummaryReportByAccountType());
    }

    public DailySummaryReportParameters getParams() {
        return this.params;
    }

    public DailySalesSummaryReportSearcher getSalesSearcher() {
        return this.salesSearcher;
    }

    public DailyDebtorSummaryReportSearcher getDebtorSearcher() {
        return this.debtorSearcher;
    }

    public DailyProductivitySummaryReportSearcher getProductivitySearcher() {
        return this.productivitySearcher;
    }

    public DailyReconciliationSummaryReportSearcher getReconciliationSearcher() {
        return this.reconciliationSearcher;
    }

    public DailyNumPatronsByAccountSearcher getPatronsByAccountSearcher() {
        return this.numPatronsSearcher;
    }

    public DailyKTSReportSearcher getKTSSearcher() {
        return this.ktsSearcher;
    }

    public DailyVoucherSummaryReportSearcher getVoucherSearcher() {
        return this.voucherSearcher;
    }

    public void setParams(DailySummaryReportParameters params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("Cannot have null searcher Parameters");
        }
        this.params = params2;
        this.salesSearcher.setSearchParameters(this.params);
        this.debtorSearcher.setSearchParameters(this.params);
        this.productivitySearcher.setSearchParameters(this.params);
        this.reconciliationSearcher.setSearchParameters(this.params);
        this.numPatronsSearcher.setSearchParameters(this.params);
        this.ktsSearcher.setSearchParameters(this.params);
        this.voucherSearcher.setSearchParameters(this.params);
    }
}

