/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.queries.finance.voucher.VoucherTransactionQueries;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReport;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcherI;

public class DailyVoucherSummaryReportSearcher
extends PropertySearcher<DailyVoucherSummaryReport>
implements DailySummaryReportSearcherI {
    private DailySummaryReportParameters params;
    private final DateRangeSearchFilter topupsDateRangeFilter;
    private final DateRangeSearchFilter redeemsDateRangeFilter;
    private final DateRangeSearchFilter reversalsDateRangeFilter;

    public DailyVoucherSummaryReportSearcher() {
        super(DailyVoucherSummaryReport.class);
        this.topupsDateRangeFilter = new OptimisedDateRangeSearchFilter(GiftVoucherTransaction.Properties.CREATION_DATE, SQLDateType.DATE);
        this.redeemsDateRangeFilter = new OptimisedDateRangeSearchFilter(GiftVoucherTransaction.Properties.CREATION_DATE, SQLDateType.DATE);
        this.reversalsDateRangeFilter = new OptimisedDateRangeSearchFilter(GiftVoucherTransaction.Properties.CREATION_DATE, SQLDateType.DATE);
    }

    @Override
    public void setSearchParameters(DailySummaryReportParameters theParams) {
        if (this.params != null) {
            this.removeSearchFilter(this.topupsDateRangeFilter);
        }
        this.params = theParams;
        this.addSearchFilter(this.topupsDateRangeFilter);
    }

    @Override
    public ObjectQuery getObjectQuery() {
        Date start = this.params.getStart();
        Date end = this.params.getEnd();
        this.topupsDateRangeFilter.setStart(start);
        this.topupsDateRangeFilter.setEnd(end);
        this.redeemsDateRangeFilter.setStart(start);
        this.redeemsDateRangeFilter.setEnd(end);
        this.reversalsDateRangeFilter.setStart(start);
        this.reversalsDateRangeFilter.setEnd(end);
        return super.getObjectQuery();
    }

    public ObjectQuery getTopupsQuery() {
        ObjectQuery topupsQuery = VoucherTransactionQueries.getTopupsSumByDaysOfWeek(this.params);
        topupsQuery = this.topupsDateRangeFilter.addQueryRestriction(topupsQuery);
        return topupsQuery;
    }

    public ObjectQuery getRedeemsQuery() {
        ObjectQuery redeemsQuery = VoucherTransactionQueries.getRedeemsSumByDaysOfWeek(this.params);
        redeemsQuery = this.redeemsDateRangeFilter.addQueryRestriction(redeemsQuery);
        return redeemsQuery;
    }

    public ObjectQuery getTopupReversalsQuery() {
        ObjectQuery topupReversalsQuery = VoucherTransactionQueries.getTopupReversalsSumByDaysOfWeek(this.params);
        topupReversalsQuery = this.reversalsDateRangeFilter.addQueryRestriction(topupReversalsQuery);
        return topupReversalsQuery;
    }

    public ObjectQuery getRedeemReversalsQuery() {
        ObjectQuery redeemReversalsQuery = VoucherTransactionQueries.getRedeemReversalsSumByDaysOfWeek(this.params);
        redeemReversalsQuery = this.reversalsDateRangeFilter.addQueryRestriction(redeemReversalsQuery);
        return redeemReversalsQuery;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return this.getTopupsQuery();
    }
}

