/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.debtor;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.reports.debtor.DebtorOutstandingItemsReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class DebtorOutstandingItemsReportSearcher
extends PropertySearcher<DebtorOutstandingItemsReport> {
    private ObjectSearchFilter<AbstractDebtor> debtorSearch;

    public DebtorOutstandingItemsReportSearcher() {
        super(DebtorOutstandingItemsReport.class);
        this.debtorSearch = new ObjectSearchFilter<AbstractDebtor>(DebtorSale.Properties.DEBTOR);
        this.addSearchFilter(this.debtorSearch);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return new ObjectQuery().sum(SalesItemQuantity.Properties.QUANTITY, "qty").select(SalesComponent.Properties.INVENTORY_ITEM).sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total_price").linkUsing(DebtorSale.Properties.SALE_ACCOUNT).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).equals(DebtorSale.Properties.PAID, false).groupBy(InventoryItem.Properties.ID);
    }

    public void setDebtorSearch(AbstractDebtor debtor) {
        this.debtorSearch.setSearchValue(debtor);
    }
}

