/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.debtor;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.debtor.DebtorSalesItemReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;

public class DebtorSalesItemReportSearcher
extends PropertySearcher<DebtorSalesItemReport> {
    private SingleValueQuerySearchFilter<TradingDay> tradingDayFilter;
    private DateRangeSearchFilter dateSearch;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionJoinSearchFilter shiftConfigFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;

    public DebtorSalesItemReportSearcher() {
        super(DebtorSalesItemReport.class);
        this.tradingDayFilter = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.dateSearch = new OptimisedDateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateSearch);
        this.shiftConfigFilter = new MultiOptionJoinSearchFilter(ConfigShift.getAllConfigShiftIds(), Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftConfigFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SalesItemQuantity.Properties.ID).select(SalesItemQuantity.Properties.ID, "fk_sales_item_quantity").select(AbstractDebtor.Properties.ID, "fk_debtor").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, DebtorSale.Properties.SALE_ACCOUNT).linkUsing(DebtorSale.Properties.DEBTOR, AbstractDebtor.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID).whereFunction("sales_item.type = 'SalesItem'").orderBy(AbstractDebtor.Properties.GROUP).orderBy(DebtorSale.Properties.DEBTOR).orderBy(SalesItemQuantity.Properties.CREATION_TIME).orderBy(SalesItemQuantity.Properties.ID);
        return query;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        return super.getObjectQuery();
    }

    public SingleValueQuerySearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public DateRangeSearchFilter getDateFilter() {
        return this.dateSearch;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public MultiOptionJoinSearchFilter getShiftConfigFilter() {
        return this.shiftConfigFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

