/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.debtor;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.BooleanQueryFilter;
import au.com.ordermate.oquery.search.filter.implementation.DebtorStatusSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SystemStateSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;

public class DebtorSearcher
extends PropertySearcher<AbstractDebtor> {
    private MultiOptionSearchFilter debtorGroupFilter;
    private ISingleValueSearchFilter debtorNameFilter;
    private SingleValueQuerySearchFilter customerFilter;
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private BooleanSearchFilter outstandingAmountFilter;
    private ISingleValueSearchFilter<String> debtorStatusFilter;
    private BooleanSearchFilter systemStateFilter;

    public DebtorSearcher() {
        super(AbstractDebtor.class);
        this.debtorGroupFilter = new MultiOptionSearchFilter<DebtorGroup>(AbstractDebtor.Properties.GROUP);
        this.debtorNameFilter = new TextSearchFilter(AbstractDebtor.Properties.LABEL);
        this.customerFilter = new ObjectSearchFilter(CustomerDebtor.Properties.CUSTOMER);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(AbstractDebtor.Properties.LAST_ACTIVITY_DATE, SQLDateType.TIMESTAMP);
        this.outstandingAmountFilter = new BooleanQueryFilter(AbstractDebtor.Properties.AMOUNT_OUTSTANDING);
        this.debtorStatusFilter = new DebtorStatusSearchFilter();
        this.systemStateFilter = new SystemStateSearchFilter(AbstractDebtor.class);
        this.addSearchFilter(this.debtorGroupFilter);
        this.addSearchFilter(this.debtorNameFilter);
        this.addSearchFilter(this.customerFilter);
        this.addSearchFilter(this.outstandingAmountFilter);
        this.addSearchFilter(this.debtorStatusFilter);
        this.addSearchFilter(this.systemStateFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass());
    }

    public MultiOptionSearchFilter getDebtorGroupFilter() {
        return this.debtorGroupFilter;
    }

    public ISingleValueSearchFilter getDebtorNameFilter() {
        return this.debtorNameFilter;
    }

    public SingleValueQuerySearchFilter getCustomerFilter() {
        return this.customerFilter;
    }

    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public BooleanSearchFilter getOutstandingAmountFilter() {
        return this.outstandingAmountFilter;
    }

    public ISingleValueSearchFilter getDebtorStatusFilter() {
        return this.debtorStatusFilter;
    }

    public BooleanSearchFilter getSystemStateFilter() {
        return this.systemStateFilter;
    }
}

