/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.driver;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Collection;
import java.util.Date;
import ordermate.database.filters.TradingDayByDateFilterAdapter;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.driver.DriverManifestReport;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;

public class DriverManifestReportSearcher
extends PropertySearcher<DriverManifestReport> {
    private ObjectSearchFilter<TradingDay> tradingDayFilter;
    private TradingDayByDateFilterAdapter tradingDayDateFilter;
    private final MultiOptionSearchFilter driverSearchFilter;

    public DriverManifestReportSearcher() {
        super(DriverManifestReport.class);
        this.tradingDayFilter = new ObjectSearchFilter(PhoneAccount.Properties.TRADING_DAY);
        this.tradingDayDateFilter = new TradingDayByDateFilterAdapter(this.tradingDayFilter);
        this.driverSearchFilter = new MultiOptionSearchFilter(User.Properties.ID);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.driverSearchFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(PhoneAccount.Properties.ID, "FK_sales_account").select(PhoneAccount.Properties.DELIVERY, "FK_sales_delivery").select(PhoneAccount.Properties.CUSTOMER, "FK_sales_customer").select(Delivery.Properties.DRIVER, "FK_config_user_driver").select(PhoneAccount.Properties.TIME_DUE, "time_due").select(PhoneAccount.Properties.DATE_DUE, "date_due").select(Delivery.Properties.TIME_CREATED, "time_created").selectFunc("if(time_due is null, timestamp(time_created), if(date_due is null, timestamp(date(time_created),time_due), timestamp(date_due, time_due))) as due_datetime ").linkUsing(PhoneAccount.Properties.DELIVERY, Delivery.Properties.ID).linkUsing(PhoneAccount.Properties.CUSTOMER, Customer.Properties.ID).linkUsing(Delivery.Properties.DRIVER, User.Properties.ID).equals(PhoneAccount.Properties.DELIVERED, "1").orderBy(User.Properties.ID).orderBy("due_datetime", false);
        return oQuery;
    }

    @FilterConfig(name="Drivers", plural=FilterConfig.Plural.Multiple, dataType=User.class, where="active = 1 AND hidden = 0 AND is_driver = 1", order="Surname, Firstname", priority=true, sequence=2)
    public MultiOptionSearchFilter getDriverFilter() {
        return this.driverSearchFilter;
    }

    public void setDrivers(Collection listOfDrivers) {
        this.driverSearchFilter.setSearchOptions(listOfDrivers);
    }

    public ObjectSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @FilterConfig(name="Trading Day", defaultValue="DateRange", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public ISingleValueSearchFilter<Date> getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }
}

