/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.hourlysales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayByDateFilterAdapter;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.hourlysales.HourlySalesReport;
import ordermate.database.reports.hourlysales.HourlySalesValueType;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;

public abstract class HourlySalesReportSearcher
extends PropertySearcher<HourlySalesReport> {
    private ObjectSearchFilter<TradingDay> tradingDayFilter;
    private TradingDayByDateFilterAdapter tradingDayDateFilter;
    private final ISingleValueSearchFilter<Boolean> hideZerosFilter;
    private final MultiOptionSearchFilter<HourlySalesValueType> valueTypeFilter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;

    public HourlySalesReportSearcher() {
        super(HourlySalesReport.class);
        this.tradingDayFilter = new ObjectSearchFilter<TradingDay>(SalesItemQuantity.Properties.TRADING_DAY);
        this.tradingDayDateFilter = new TradingDayByDateFilterAdapter(this.tradingDayFilter);
        this.hideZerosFilter = new BooleanSearchFilter(null);
        this.valueTypeFilter = new MultiOptionSearchFilter(null);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.tradingDayFilter.setSearchValue(TradingDay.getCurrentTradingDay());
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.sum(SalesItemQuantity.Properties.QUANTITY, "qty_sold").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "sales").selectFunc("HOUR(sales_item_quantity.creation_time) AS 'time_bracket'").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesComponent.Properties.SALES_ITEM).groupBy("time_bracket");
        query = this.selectGroups(query);
        return query;
    }

    @Override
    public List<HourlySalesReport> search() {
        this.tradingDayDateFilter.update();
        if (!this.tradingDayFilter.hasSearchValue()) {
            return Collections.emptyList();
        }
        return super.search();
    }

    protected abstract ObjectQuery selectGroups(ObjectQuery var1);

    @FilterConfig(name="Trading Day", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public TradingDayByDateFilterAdapter getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }

    @FilterConfig(name="Hide Zeros", plural=FilterConfig.Plural.Single, dataType=Boolean.class, nullAllowed=true, priority=true, sequence=3)
    public ISingleValueSearchFilter<Boolean> getHideZeroFilter() {
        return this.hideZerosFilter;
    }

    @FilterConfig(name="Value Type", plural=FilterConfig.Plural.Multiple, dataType=HourlySalesValueType.class, nullAllowed=true, priority=true, sequence=2)
    public MultiOptionSearchFilter getTypeValueFilter() {
        return this.valueTypeFilter;
    }

    @FilterConfig(name="Sales Location", plural=FilterConfig.Plural.Multiple, dataType=SalesLocation.class, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public ObjectSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    public boolean getHideZeroFilterValue() {
        Boolean value = this.hideZerosFilter.getSearchValue();
        if (value == null) {
            return false;
        }
        return value;
    }

    public HourlySalesValueType getValueTypeFilterValue() {
        List<HourlySalesValueType> selected = this.valueTypeFilter.getSelectedOptions();
        if (selected == null || selected.isEmpty()) {
            return HourlySalesValueType.Sales;
        }
        return selected.get(0);
    }
}

