/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.productivity;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.GlazedLists;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.queries.users.UserQueries;
import ordermate.database.reports.productivity.ProductivityReport;
import ordermate.database.searchers.reports.productivity.ProductivityReportSearcher;
import ordermate.database.users.User;
import org.apache.commons.collections.map.MultiKeyMap;

public class ProductivityReportCompiler {
    private ProductivityReportSearcher searcher;
    public static final String TRAD_COL_NAME = "Trading Day";
    private List<List<List<String>>> reportData;
    private List<List<String>> tradingDaySummaryData;
    private List<List<String>> userSummaryData;
    private static final int NUM_USERS_PER_REPORT = 16;
    private List<List<String>> reportColumnNames;
    private DateFormat format = DateTimeUtils.getDateMonthYearFormat();
    private boolean isSpliteFlag = true;

    public ProductivityReportCompiler(ProductivityReportSearcher fromTableState) {
        this.searcher = fromTableState;
    }

    public void setIsSpliteFlag(boolean isSpliteFlag) {
        this.isSpliteFlag = isSpliteFlag;
    }

    public List<String> getColumnNames(int index) {
        return this.reportColumnNames.get(index);
    }

    private List<User> getUserList() {
        ArrayList<User> userList = new ArrayList<User>(this.searcher.getUserSearchFilter().getSelectedOptions());
        if (userList.isEmpty()) {
            userList.addAll((Collection<User>)GlazedLists.eventList(UserQueries.getAllUsersIncDeleted()));
        }
        Collections.sort(userList, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                int res = o1.getFirstName().compareToIgnoreCase(o2.getFirstName());
                if (res != 0) {
                    return res;
                }
                return o1.getLastName().compareToIgnoreCase(o2.getLastName());
            }
        });
        return userList;
    }

    public List<String> getTradingDaySummaryColumnNames() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add(TRAD_COL_NAME);
        newList.add("Average Total Sales Per Patron");
        return newList;
    }

    public List<String> getUserSummaryColumnNames() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("User");
        newList.add("Average Total Sales Per Patron");
        return newList;
    }

    private List<ProductivityReport> getReports() {
        List<ProductivityReport> databaseData = this.searcher.search();
        Collections.sort(databaseData, new Comparator<ProductivityReport>(){

            @Override
            public int compare(ProductivityReport o1, ProductivityReport o2) {
                int tradingDayComp = o1.getTradingDay().compareTo(o2.getTradingDay());
                return tradingDayComp != 0 ? tradingDayComp : o1.getUser().getID().compareTo(o2.getUser().getID());
            }
        });
        return databaseData;
    }

    private List<Date> getTradingDayDates() {
        ArrayList<Date> dateList = new ArrayList<Date>();
        IRangedQuerySearchFilter<Date> dateRangeFilter = this.searcher.getTradingDayDateRangeFilter();
        if (dateRangeFilter != null) {
            for (TradingDay day : TradingDayQueries.getTradingDaysBetweenDates((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd())) {
                dateList.add(day.getDate());
            }
        } else {
            for (TradingDay day : TradingDay.getAllTradingDays()) {
                dateList.add(day.getDate());
            }
        }
        return dateList;
    }

    public void buildData() {
        this.reportData = new ArrayList<List<List<String>>>();
        this.buildReportColumnNames();
        List<ProductivityReport> databaseData = this.getReports();
        this.buildReportData(databaseData);
        this.buildUserSummaryData(databaseData);
        this.buildTradingDaySummaryData(databaseData);
    }

    private void buildReportData(List<ProductivityReport> databaseData) {
        for (List<String> colHeaders : this.reportColumnNames) {
            ArrayList reportDataTable = new ArrayList();
            MultiKeyMap userReportMap = new MultiKeyMap();
            for (ProductivityReport report : databaseData) {
                String keyUser = report.getUser().toString();
                Date keyDate = report.getTradingDay();
                if (!colHeaders.contains(keyUser) || userReportMap.get((Object)keyUser, (Object)keyDate) != null) continue;
                userReportMap.put((Object)keyUser, (Object)keyDate, (Object)report);
            }
            for (Date tradingDayDate : this.getTradingDayDates()) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(this.format.format(tradingDayDate));
                Price totalSales = Price.ZERO_DOLLAR;
                Integer totalPatrons = 0;
                for (String str : colHeaders) {
                    ProductivityReport element = (ProductivityReport)userReportMap.get((Object)str, (Object)tradingDayDate);
                    if (element != null && str.equals(element.getUser().toString())) {
                        totalSales = totalSales.add(element.getSalesTotal());
                        totalPatrons = new Integer(totalPatrons + element.getPatronTotal());
                        row.add(element.getSalesPerPatron().toString());
                        continue;
                    }
                    if (str.equals(TRAD_COL_NAME)) continue;
                    row.add(Price.ZERO_DOLLAR.toString());
                }
                reportDataTable.add(row);
            }
            this.reportData.add(reportDataTable);
        }
    }

    private void buildReportColumnNames() {
        this.reportColumnNames = new ArrayList<List<String>>();
        List<User> usersToBuildReportsFor = this.getUserList();
        if (!this.isSpliteFlag) {
            ArrayList<String> columnHeader = new ArrayList<String>();
            columnHeader.add(TRAD_COL_NAME);
            for (int i = 0; i < usersToBuildReportsFor.size(); ++i) {
                columnHeader.add(usersToBuildReportsFor.get(i).toString());
            }
            this.reportColumnNames.add(columnHeader);
        } else {
            Iterator<User> users = usersToBuildReportsFor.iterator();
            while (users.hasNext()) {
                ArrayList<String> columnHeader = new ArrayList<String>();
                columnHeader.add(TRAD_COL_NAME);
                for (int i = 0; i < 16 && users.hasNext(); ++i) {
                    columnHeader.add(((Object)users.next()).toString());
                }
                this.reportColumnNames.add(columnHeader);
            }
        }
    }

    private void buildUserSummaryData(List<ProductivityReport> databaseData) {
        this.userSummaryData = new ArrayList<List<String>>();
        List<User> userList = this.getUserList();
        HashMap<User, Price> userSalesMap = new HashMap<User, Price>();
        HashMap<User, Integer> userPatronMap = new HashMap<User, Integer>();
        for (ProductivityReport report : databaseData) {
            User keyUser = report.getUser();
            if (userSalesMap.get(keyUser) == null) {
                userSalesMap.put(keyUser, Price.ZERO_DOLLAR);
                userPatronMap.put(keyUser, new Integer(0));
            }
            userSalesMap.put(keyUser, ((Price)userSalesMap.get(keyUser)).add(report.getSalesTotal()));
            userPatronMap.put(keyUser, new Integer((Integer)userPatronMap.get(keyUser) + report.getPatronTotal()));
        }
        for (User thisUser : userList) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(thisUser.toString());
            if (userSalesMap.containsKey(thisUser)) {
                row.add(((Price)userSalesMap.get(thisUser)).divide((Integer)userPatronMap.get(thisUser)).toString());
            } else {
                row.add(Price.ZERO_DOLLAR.toString());
            }
            this.userSummaryData.add(row);
        }
    }

    private void buildTradingDaySummaryData(List<ProductivityReport> databaseData) {
        this.tradingDaySummaryData = new ArrayList<List<String>>();
        List<Date> dateList = this.getTradingDayDates();
        HashMap<Date, Price> userSalesMap = new HashMap<Date, Price>();
        HashMap<Date, Integer> userPatronMap = new HashMap<Date, Integer>();
        for (ProductivityReport report : databaseData) {
            Date keyDate = report.getTradingDay();
            if (userSalesMap.get(keyDate) == null) {
                userSalesMap.put(keyDate, Price.ZERO_DOLLAR);
                userPatronMap.put(keyDate, new Integer(0));
            }
            userSalesMap.put(keyDate, ((Price)userSalesMap.get(keyDate)).add(report.getSalesTotal()));
            userPatronMap.put(keyDate, new Integer((Integer)userPatronMap.get(keyDate) + report.getPatronTotal()));
        }
        for (Date thisDate : dateList) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(this.format.format(thisDate));
            if (userSalesMap.containsKey(thisDate)) {
                row.add(((Price)userSalesMap.get(thisDate)).divide((Integer)userPatronMap.get(thisDate)).toString());
            } else {
                row.add(Price.ZERO_DOLLAR.toString());
            }
            this.tradingDaySummaryData.add(row);
        }
    }

    public List<List<String>> getData(int index) {
        return this.reportData.get(index);
    }

    public List<List<String>> getTradingDaySummaryData() {
        return this.tradingDaySummaryData;
    }

    public List<List<String>> getUserSummaryData() {
        return this.userSummaryData;
    }

    public List<ProductivityReport> getSearcherData() {
        return this.searcher.search();
    }

    public int getColumnNamesCount() {
        return this.reportColumnNames.size();
    }

    public ProductivityReportSearcher getSearcher() {
        return this.searcher;
    }
}

