/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.productivity;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.UserTypeSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Arrays;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.productivity.ProductivityReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;

public class ProductivityReportSearcher
extends PropertySearcher<ProductivityReport>
implements TradingDayFilteredReportSearcher<ProductivityReport> {
    private final ObjectSearchFilter<TradingDay> tradingDaySearch;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearch;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter userSearchFilter;
    private final MultiOptionJoinSearchFilter groupSearchFilter;
    private MultiOptionJoinSearchFilter<String> shiftNameSearch;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private String userTypeFlag;
    public static final String configUserType = "Base User Performance Off";
    public static final String userType_Open = "User who opened the table";
    public static final String userType_Assign = "User who ordered the first item";
    private ISingleValueSearchFilter<String> userTypeSearchFilter;

    public ProductivityReportSearcher() {
        super(ProductivityReport.class);
        this.tradingDaySearch = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearch = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeSearch);
        this.userSearchFilter = new MultiOptionSearchFilter<User>(Account.Properties.OPENING_USER);
        this.groupSearchFilter = new MultiOptionJoinSearchFilter(Account.Properties.ASSIGNED_USER, User.Properties.PERMISSION_GROUP);
        this.shiftNameSearch = new MultiOptionJoinSearchFilter(Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.LABEL);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.userTypeSearchFilter = new UserTypeSearchFilter();
        this.setUserTypeFilter();
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftNameSearch);
        this.addSearchFilter(this.groupSearchFilter);
        this.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.userSearchFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.selectFunc("finance_trading_day.day as trading_day_name");
        if (this.userSearchFilter.getProperty().equals(Account.Properties.ASSIGNED_USER)) {
            query.select(Account.Properties.ASSIGNED_USER, "user");
        } else {
            query.select(Account.Properties.OPENING_USER, "user");
        }
        query.sum(Account.Properties.SAVED_TOTAL, "total_sum").sum(Account.Properties.NUM_PATRONS, "total_patrons").linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID).equals(Account.Properties.ACCOUNT_STATE, "Closed");
        if (this.userSearchFilter.getProperty().equals(Account.Properties.ASSIGNED_USER)) {
            query.not().isNull(Account.Properties.ASSIGNED_USER);
            query.linkUsing(Account.Properties.ASSIGNED_USER, User.Properties.ID);
        } else {
            query.not().isNull(Account.Properties.OPENING_USER);
            query.linkUsing(Account.Properties.OPENING_USER, User.Properties.ID);
        }
        query.not().equals(Account.Properties.NUM_PATRONS, "0").whereIn("account_type", Arrays.asList(AccountType.tableType, AccountType.onlineTableType));
        if (this.userSearchFilter.getProperty().equals(Account.Properties.ASSIGNED_USER)) {
            query.groupBy(Account.Properties.TRADING_DAY).groupBy(Account.Properties.ASSIGNED_USER);
        } else {
            query.groupBy(Account.Properties.TRADING_DAY).groupBy(Account.Properties.OPENING_USER);
        }
        query.orderBy(Account.Properties.TRADING_DAY).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME);
        return query;
    }

    @Override
    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateRangeSearch;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearch;
    }

    public void setUserTypeFilter() {
        if (this.isUserPerformanceBasedOffOpeningUser()) {
            this.getUserSearchFilter().setProperty(Account.Properties.OPENING_USER);
        } else {
            this.getUserSearchFilter().setProperty(Account.Properties.ASSIGNED_USER);
        }
    }

    public void setUserTypeFilter(String userType) {
        if (userType.equals(userType_Open)) {
            this.getUserSearchFilter().setProperty(Account.Properties.OPENING_USER);
        } else if (userType.equals(userType_Assign)) {
            this.getUserSearchFilter().setProperty(Account.Properties.ASSIGNED_USER);
        }
    }

    public boolean isUserPerformanceBasedOffOpeningUser() {
        ReportProperty userTypeFlagRP = ReportProperty.find(ReportGroup.General, configUserType);
        this.userTypeFlag = userTypeFlagRP.getValue();
        return !this.userTypeFlag.equalsIgnoreCase(userType_Assign);
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=2)
    public MultiOptionSearchFilter getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @FilterConfig(name="User Group", dataType=PermissionGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=3)
    public MultiOptionSearchFilter getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=4)
    public MultiOptionJoinSearchFilter<String> getShiftSearchFilter() {
        return this.shiftNameSearch;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @FilterConfig(name="User Type", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=5)
    public ISingleValueSearchFilter getUserTypeSearchFilter() {
        this.setUserTypeFilter();
        return this.userTypeSearchFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

